/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer.stats;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.pixeldreamstudios.showmeyourbuild.client.gui.BuildViewScreen;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatEntry;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatRow;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatsRenderUtils;

@Environment(value=EnvType.CLIENT)
public class StatGroup
extends StatEntry {
    private final class_2960 icon;
    final String label;
    private final String value;
    final String tooltip;
    private final List<StatRow> children = new ArrayList<StatRow>();
    private boolean expanded;
    private static final int SLOT_WIDTH = 100;
    private static final int SLOT_HEIGHT = 18;

    public StatGroup(class_2960 icon, String label, String value, boolean expanded, String tooltip, int column) {
        this.icon = icon;
        this.label = label;
        this.value = value;
        this.tooltip = tooltip;
        this.expanded = expanded;
        this.column = column;
    }

    @Override
    public void render(class_332 ctx, class_327 tr, int columnX, int y) {
        int contentStartX;
        int iconSize = 10;
        float scale = 0.7f;
        int slotX = columnX + 0;
        ctx.method_25290(BuildViewScreen.STATS_SLOT, slotX, y, 0.0f, 0.0f, 100, 16, 100, 16);
        int arrowX = slotX + 8;
        int centerY = y + 4;
        ctx.method_25303(tr, this.expanded ? "\u25bc" : "\u25b6", arrowX, centerY, 0xAAAAAA);
        int labelWidth = (int)((float)tr.method_1727(this.label + ":") * 0.7f);
        int valueWidth = this.value != null ? (int)((float)tr.method_1727(this.value) * 0.7f) : 0;
        int iconWidth = this.icon != null ? 14 : 0;
        int totalContentWidth = iconWidth + labelWidth + (valueWidth > 0 ? 5 + valueWidth : 0);
        int nextX = contentStartX = slotX + (100 - totalContentWidth) / 2;
        if (this.icon != null) {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416((float)nextX, (float)centerY, 0.0f);
            ctx.method_51448().method_22905(1.0f, 1.0f, 1.0f);
            ctx.method_25290(this.icon, 0, -2, 0.0f, 0.0f, 10, 10, 10, 10);
            ctx.method_51448().method_22909();
            nextX += 14;
        }
        StatsRenderUtils.drawScaledText(ctx, tr, this.label + ":", nextX, centerY, 0xFFFFFF);
        nextX += labelWidth;
        if (this.value != null && !this.value.isBlank()) {
            StatsRenderUtils.drawScaledText(ctx, tr, this.value, nextX += 5, centerY, 0xAAAAAA);
        }
    }

    public void propagateColumnToChildren() {
        for (StatRow child : this.children) {
            child.column = this.column;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public void renderTooltip(class_332 ctx, class_327 tr, int mouseX, int mouseY, int x, int y, float scrollY) {
        boolean hoverValue;
        if (this.tooltip == null) {
            return;
        }
        int iconSize = 10;
        int arrowWidth = tr.method_1727("\u25b6");
        int iconX = x + arrowWidth + 2;
        int drawX = iconX + iconSize + 4;
        float scale = 0.9f;
        int[] bounds = StatsRenderUtils.computeTruncatedLabelAndValueBounds(tr, this.label, this.value != null ? this.value : "", drawX, scale, tr.method_1727("This is quite long"));
        boolean hoverIcon = mouseX >= iconX && mouseX <= iconX + iconSize && mouseY >= y && mouseY <= y + iconSize;
        boolean hoverLabel = mouseX >= bounds[0] && mouseX <= bounds[1] && mouseY >= y && mouseY <= y + iconSize;
        boolean bl = hoverValue = mouseX >= bounds[2] && mouseX <= bounds[3] && mouseY >= y && mouseY <= y + iconSize;
        if (hoverIcon || hoverLabel) {
            ctx.method_51438(tr, (class_2561)class_2561.method_43470((String)this.tooltip), mouseX, mouseY);
        } else if (hoverValue && this.value != null && !this.value.isBlank()) {
            ctx.method_51438(tr, (class_2561)class_2561.method_43470((String)this.value.trim()), mouseX, mouseY);
        }
    }

    public void toggle() {
        this.expanded = !this.expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public List<StatRow> getChildren() {
        return this.children;
    }

    public void addChild(StatRow row) {
        this.children.add(row);
    }
}

