/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer.stats;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatEntry;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatsRenderUtils;

@Environment(value=EnvType.CLIENT)
public class StatRow
extends StatEntry {
    private static final int LABEL_COLOR = 0xB0B0B0;
    private final class_2960 icon;
    private final String displayLabel;
    private final String value;
    final String tooltip;
    private final boolean indent;
    private final double delta;
    private final int color;
    private final String iconGlyph;

    public StatRow(class_2960 icon, String label, String value, String tooltip, boolean indent, int column, double delta) {
        this.icon = icon;
        this.tooltip = tooltip;
        this.indent = indent;
        this.column = column;
        this.delta = delta;
        this.color = delta > 0.0 ? 65280 : (delta < 0.0 ? 0xFF5555 : 0xAAAAAA);
        String glyph = null;
        String cleanedLabel = label;
        try {
            String stripped = IconLeadingUtil.stripSectionCodes((String)label);
            int[] span = IconLeadingUtil.firstIconSpan((String)stripped);
            if (span[0] >= 0) {
                glyph = stripped.substring(span[0], span[1]);
                cleanedLabel = (stripped.substring(0, span[0]) + stripped.substring(span[1])).trim();
            } else {
                cleanedLabel = stripped;
            }
        }
        catch (Throwable t) {
            cleanedLabel = label;
        }
        this.iconGlyph = glyph;
        this.displayLabel = cleanedLabel;
        this.value = value;
    }

    public double getDelta() {
        return this.delta;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public void render(class_332 ctx, class_327 tr, int x, int y) {
        int iconX;
        int offset = this.indent ? 10 : 0;
        int drawX = iconX = x + offset;
        boolean drewIcon = false;
        if (this.iconGlyph != null && !this.iconGlyph.isEmpty()) {
            float s = 0.8f;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(s, s, 1.0f);
            ctx.method_25303(tr, this.iconGlyph, (int)((float)iconX / s), (int)((float)(y + 1) / s), 0xFFFFFF);
            ctx.method_51448().method_22909();
            drawX = iconX + 10 + 4;
            drewIcon = true;
        } else if (this.icon != null) {
            ctx.method_25290(this.icon, iconX, y, 0.0f, 0.0f, 10, 10, 10, 10);
            drawX = iconX + 10 + 4;
            drewIcon = true;
        }
        if (!drewIcon) {
            drawX = iconX;
        }
        int maxLabelWidth = tr.method_1727("This is quite long");
        String truncatedLabel = StatsRenderUtils.truncateToWidth(tr, this.displayLabel, maxLabelWidth);
        StatsRenderUtils.drawScaledText(ctx, tr, truncatedLabel + ":", drawX, y + 2, 0xB0B0B0);
        if (this.value != null && !this.value.isBlank()) {
            int valueX = drawX + (int)((float)tr.method_1727(truncatedLabel + ":") * 0.7f) + 5;
            StatsRenderUtils.drawScaledText(ctx, tr, this.value, valueX, y + 2, this.color);
        }
    }

    @Override
    public void renderTooltip(class_332 ctx, class_327 tr, int mouseX, int mouseY, int x, int y, float scrollY) {
        boolean hoverValue;
        if (this.tooltip == null) {
            return;
        }
        int offset = this.indent ? 10 : 0;
        int iconX = x + offset;
        int drawX = this.icon != null || this.iconGlyph != null && !this.iconGlyph.isEmpty() ? iconX + 10 + 4 : iconX;
        float scale = 0.9f;
        int[] bounds = StatsRenderUtils.computeTruncatedLabelAndValueBounds(tr, this.displayLabel, this.value, drawX, scale, tr.method_1727("This is quite long"));
        boolean hasAnyIcon = this.icon != null || this.iconGlyph != null && !this.iconGlyph.isEmpty();
        boolean hoverIcon = hasAnyIcon && mouseX >= iconX && mouseX <= iconX + 10 && mouseY >= y && mouseY <= y + 10;
        boolean hoverLabel = mouseX >= bounds[0] && mouseX <= bounds[1] && mouseY >= y && mouseY <= y + 10;
        boolean bl = hoverValue = mouseX >= bounds[2] && mouseX <= bounds[3] && mouseY >= y && mouseY <= y + 10;
        if (hoverIcon || hoverLabel) {
            ctx.method_51438(tr, (class_2561)class_2561.method_43470((String)this.tooltip), mouseX, mouseY);
        } else if (hoverValue && this.value != null && !this.value.isBlank()) {
            ctx.method_51438(tr, (class_2561)class_2561.method_43470((String)this.value.trim()), mouseX, mouseY);
        }
    }
}

