/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.network;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.pixeldreamstudios.showmeyourbuild.client.BuildDataStore;
import net.pixeldreamstudios.showmeyourbuild.client.LiveEffectStore;
import net.pixeldreamstudios.showmeyourbuild.client.SkillTreeSnapshotLoader;
import net.pixeldreamstudios.showmeyourbuild.client.gui.ReadOnlySkillsScreen;
import net.pixeldreamstudios.showmeyourbuild.network.payload.SendBuildSnapshotPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.SendLiveEffectsPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.SendSkillTreeSnapshotPayload;
import net.puffish.skillsmod.client.data.ClientCategoryData;

@Environment(value=EnvType.CLIENT)
public class ClientNetwork {
    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver(SendSkillTreeSnapshotPayload.ID, (payload, context) -> context.client().execute(() -> {
            String playerName = payload.playerName();
            class_2487 data = payload.skillData();
            Map<class_2960, ClientCategoryData> categories = SkillTreeSnapshotLoader.load(data);
            Optional<class_2960> maybeFirstId = categories.keySet().stream().findFirst();
            ReadOnlySkillsScreen.open(categories.values().stream().toList(), maybeFirstId);
        }));
        ClientPlayNetworking.registerGlobalReceiver(SendBuildSnapshotPayload.ID, (payload, context) -> context.client().execute(() -> {
            String snapshotId = payload.snapshotId();
            String name = payload.playerName();
            class_2487 data = payload.data();
            BuildDataStore.save(snapshotId, data);
            BuildDataStore.save(name, data);
            class_5250 message = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("[" + name + "'s Build]")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/internal_show_build " + snapshotId)).method_36139(43732).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to view " + name + "'s Build"))))));
            class_310.method_1551().field_1724.method_7353((class_2561)message, false);
        }));
        ClientPlayNetworking.registerGlobalReceiver(SendLiveEffectsPayload.ID, (payload, context) -> context.client().execute(() -> {
            String playerName = payload.playerName();
            class_2487 effectData = payload.effectData();
            LiveEffectStore.save(playerName, effectData);
        }));
    }
}

