/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air;

import com.leclowndu93150.thick_air.ThickAir;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="thick_air", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DIMENSIONS = BUILDER.comment(new String[]{"Air qualities at different heights in different dimensions.", "The syntax is the dimension's resource location, the \"default\" air level in that dimension,", "then any number of height:airlevel pairs separated by commas.", "The air will have that quality starting at that height and above (until the next entry).", "The entries must be in ascending order of height.", "If a dimension doesn't have an entry here, it'll be assumed to be green everywhere."}).defineList("dimensions", Arrays.asList("minecraft:overworld=yellow,0:green,128:yellow", "minecraft:the_nether=yellow", "minecraft:the_end=red"), o -> {
        String s;
        return o instanceof String && Config.parseDimensionLine(s = (String)o) != null;
    });
    private static final ModConfigSpec.BooleanValue ENABLE_SIGNAL_TORCHES = BUILDER.comment("Whether to allow right-clicking torches to make them spray particle effects").define("enableSignalTorches", true);
    private static final ModConfigSpec.IntValue DROWNED_CHOKING = BUILDER.comment("How much air a Drowned attack removes. Set to 0 to disable this feature.").defineInRange("drownedChoking", 100, 0, 72000);
    private static final ModConfigSpec.DoubleValue YELLOW_AIR_PROVIDER_RADIUS = BUILDER.push("Ranges").comment("The radius in which all blocks defined in the yellow air providers tag project a bubble of air around them.").defineInRange("yellowAirProviderRadius", 6.0, 1.0, 32.0);
    private static final ModConfigSpec.DoubleValue BLUE_AIR_PROVIDER_RADIUS = BUILDER.comment("The radius in which all blocks defined in the blue air providers tag (usually soul fire related blocks) project a bubble of air around them.").defineInRange("blueAirProviderRadius", 6.0, 1.0, 32.0);
    private static final ModConfigSpec.DoubleValue RED_AIR_PROVIDER_RADIUS = BUILDER.comment("The radius in which all blocks defined in the red air providers tag (usually lava related blocks) project a bubble of air around them.").defineInRange("redAirProviderRadius", 3.0, 1.0, 32.0);
    private static final ModConfigSpec.DoubleValue GREEN_AIR_PROVIDER_RADIUS = BUILDER.comment("The radius in which all blocks defined in the green air providers tag (usually various portal blocks) project a bubble of air around them.").defineInRange("greenAirProviderRadius", 9.0, 1.0, 32.0);
    static final ModConfigSpec SPEC;
    public static boolean enableSignalTorches;
    public static int drownedChoking;
    public static double yellowAirProviderRadius;
    public static double blueAirProviderRadius;
    public static double redAirProviderRadius;
    public static double greenAirProviderRadius;
    private static Map<ResourceLocation, DimensionEntry> dimensionEntries;

    @Nullable
    private static Pair<ResourceLocation, DimensionEntry> parseDimensionLine(String line) {
        AirQualityLevel baseQuality;
        String[] dimensionVals = line.split("=");
        if (dimensionVals.length != 2) {
            ThickAir.LOGGER.warn("Couldn't parse dimension line {}: couldn't split across `=` into 2 parts", (Object)line);
            return null;
        }
        ResourceLocation dimkey = ResourceLocation.tryParse((String)dimensionVals[0]);
        if (dimkey == null) {
            ThickAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid resource location", (Object)line, (Object)dimensionVals[0]);
            return null;
        }
        String[] heightAndRest = dimensionVals[1].split(",", 2);
        try {
            baseQuality = AirQualityLevel.valueOf(heightAndRest[0].toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            ThickAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid base air quality", (Object)line, (Object)heightAndRest[0]);
            return null;
        }
        ArrayList<Pair<Integer, AirQualityLevel>> heights = new ArrayList<Pair<Integer, AirQualityLevel>>();
        if (heightAndRest.length == 2) {
            String[] heightPairStrs = heightAndRest[1].split(",");
            Integer prevHeight = null;
            for (String heightPairStr : heightPairStrs) {
                AirQualityLevel quality;
                int height;
                String[] pairStr = heightPairStr.split(":");
                if (pairStr.length != 2) {
                    ThickAir.LOGGER.warn("Couldn't parse dimension line {}: couldn't use {} as a height entry", (Object)line, (Object)heightPairStr);
                    return null;
                }
                try {
                    height = Integer.parseInt(pairStr[0]);
                }
                catch (NumberFormatException e) {
                    ThickAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid int", (Object)line, (Object)pairStr[0]);
                    return null;
                }
                if (prevHeight != null && height <= prevHeight) {
                    return null;
                }
                prevHeight = height;
                try {
                    quality = AirQualityLevel.valueOf(pairStr[1].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    ThickAir.LOGGER.warn("Couldn't parse dimension line {}: {} isn't a valid air quality", (Object)line, (Object)pairStr[1]);
                    return null;
                }
                heights.add((Pair<Integer, AirQualityLevel>)Pair.of((Object)height, (Object)((Object)quality)));
            }
        }
        return Pair.of((Object)dimkey, (Object)new DimensionEntry(baseQuality, heights));
    }

    public static AirQualityLevel getAirQualityAtLevelByDimension(ResourceLocation dimension, int y) {
        if (dimensionEntries == null) {
            List lines = (List)DIMENSIONS.get();
            dimensionEntries = new HashMap<ResourceLocation, DimensionEntry>(lines.size());
            for (String line : lines) {
                Pair<ResourceLocation, DimensionEntry> entry = Config.parseDimensionLine(line);
                if (entry == null) {
                    ThickAir.LOGGER.warn("Somehow managed to get a bad dimension config past the validator?!");
                    continue;
                }
                dimensionEntries.put((ResourceLocation)entry.getLeft(), (DimensionEntry)entry.getRight());
            }
        }
        if (dimensionEntries.containsKey(dimension)) {
            DimensionEntry entry = dimensionEntries.get(dimension);
            List<Pair<Integer, AirQualityLevel>> heights = entry.heights;
            for (int i = 0; i < heights.size(); ++i) {
                Pair<Integer, AirQualityLevel> heightPair = heights.get(heights.size() - i - 1);
                if (y < (Integer)heightPair.getLeft()) continue;
                return (AirQualityLevel)((Object)heightPair.getRight());
            }
            return entry.baseQuality;
        }
        return AirQualityLevel.GREEN;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        enableSignalTorches = (Boolean)ENABLE_SIGNAL_TORCHES.get();
        drownedChoking = (Integer)DROWNED_CHOKING.get();
        yellowAirProviderRadius = (Double)YELLOW_AIR_PROVIDER_RADIUS.get();
        blueAirProviderRadius = (Double)BLUE_AIR_PROVIDER_RADIUS.get();
        redAirProviderRadius = (Double)RED_AIR_PROVIDER_RADIUS.get();
        greenAirProviderRadius = (Double)GREEN_AIR_PROVIDER_RADIUS.get();
        dimensionEntries = null;
    }

    static {
        BUILDER.pop();
        SPEC = BUILDER.build();
        dimensionEntries = null;
    }

    private record DimensionEntry(AirQualityLevel baseQuality, List<Pair<Integer, AirQualityLevel>> heights) {
    }
}

