/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.api;

import com.leclowndu93150.thick_air.Config;
import com.leclowndu93150.thick_air.ModRegistry;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import com.leclowndu93150.thick_air.capability.AirBubblePositions;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public final class AirQualityHelper {
    private AirQualityHelper() {
    }

    public static AirQualityLevel getAirQualityAtLocation(LivingEntity entity) {
        return AirQualityHelper.getAirQualityAtLocation(entity.level(), entity.getEyePosition());
    }

    public static AirQualityLevel getAirQualityAtLocation(Level level, Vec3 location) {
        BlockState blockAtEyes = level.getBlockState(BlockPos.containing((Position)location));
        AirQualityLevel airQualityAtEyes = AirQualityLevel.getAirQualityAtEyes(blockAtEyes);
        if (airQualityAtEyes != null) {
            return airQualityAtEyes;
        }
        AirQualityLevel bestAirBubbleQuality = null;
        ChunkPos chunkAtCenter = new ChunkPos(BlockPos.containing((Position)location));
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkPos posInChunk = new ChunkPos(chunkAtCenter.x + x, chunkAtCenter.z + z);
                LevelChunk chunk = level.getChunkSource().getChunkNow(posInChunk.x, posInChunk.z);
                if (chunk == null) continue;
                AirBubblePositions capability = (AirBubblePositions)chunk.getData(ModRegistry.AIR_BUBBLE_POSITIONS);
                Map<BlockPos, AirQualityLevel> airBubblePositions = capability.getAirBubblePositionsView();
                for (Map.Entry<BlockPos, AirQualityLevel> entry : airBubblePositions.entrySet()) {
                    double radiusSq;
                    double distanceSq;
                    BlockPos blockPos = entry.getKey();
                    AirQualityLevel airQualityLevel = entry.getValue();
                    Objects.requireNonNull(airQualityLevel, "air quality level is null");
                    if (bestAirBubbleQuality != null && !airQualityLevel.isBetterThan(bestAirBubbleQuality) || !((distanceSq = location.distanceToSqr((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5)) < (radiusSq = airQualityLevel.getAirProviderRadius() * airQualityLevel.getAirProviderRadius()))) continue;
                    if (airQualityLevel == AirQualityLevel.GREEN) {
                        return AirQualityLevel.GREEN;
                    }
                    bestAirBubbleQuality = airQualityLevel;
                }
            }
        }
        if (bestAirBubbleQuality != null) {
            return bestAirBubbleQuality;
        }
        return Config.getAirQualityAtLevelByDimension(level.dimension().location(), (int)Math.round(location.y));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSensitiveToAirQuality(LivingEntity entity) {
        if (!entity.getType().is(ModRegistry.AIR_QUALITY_SENSITIVE_ENTITY_TYPE_TAG)) return false;
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.getAbilities().invulnerable) return false;
        return true;
    }
}

