/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.api;

import com.leclowndu93150.thick_air.Config;
import com.leclowndu93150.thick_air.ThickAir;
import com.leclowndu93150.thick_air.compat.CuriosCompat;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public enum AirQualityLevel implements StringRepresentable
{
    GREEN(true, true){

        @Override
        boolean isProtected(LivingEntity entity) {
            return false;
        }

        @Override
        int getAirAmount(LivingEntity entity) {
            return 4;
        }
    }
    ,
    BLUE(true, false){

        @Override
        boolean isProtected(LivingEntity entity) {
            return false;
        }

        @Override
        int getAirAmount(LivingEntity entity) {
            return 0;
        }
    }
    ,
    YELLOW(false, false, "breathing_equipment"){

        @Override
        int getAirAmount(LivingEntity entity) {
            return entity.level().getGameTime() % 4L == 0L ? super.getAirAmount(entity) : 0;
        }
    }
    ,
    RED(false, false, "heavy_breathing_equipment");

    public static final StringRepresentable.EnumCodec<AirQualityLevel> CODEC;
    public final boolean canBreathe;
    public final boolean canRefillAir;
    @Nullable
    private final TagKey<Item> breathingEquipment;
    private final TagKey<Block> airProviders;

    private AirQualityLevel(boolean canBreathe, boolean canRefillAir) {
        this(canBreathe, canRefillAir, null);
    }

    private AirQualityLevel(@Nullable boolean canBreathe, boolean canRefillAir, String breathingEquipment) {
        this.canBreathe = canBreathe;
        this.canRefillAir = canRefillAir;
        this.breathingEquipment = breathingEquipment != null ? TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ThickAir.id(breathingEquipment)) : null;
        this.airProviders = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ThickAir.id(this.getSerializedName() + "_air_providers"));
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public TagKey<Item> getBreathingEquipment() {
        Objects.requireNonNull(this.breathingEquipment, "breathing equipment is null");
        return this.breathingEquipment;
    }

    public TagKey<Block> getAirProvidersTag() {
        return this.airProviders;
    }

    public double getAirProviderRadius() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> Config.redAirProviderRadius;
            case 0 -> Config.greenAirProviderRadius;
            case 2 -> Config.yellowAirProviderRadius;
            case 1 -> Config.blueAirProviderRadius;
        };
    }

    public int getLightLevel() {
        return 15 - this.ordinal() * 3;
    }

    public int getOutputSignal() {
        return this.ordinal() + 1;
    }

    public boolean isBetterThan(AirQualityLevel other) {
        return this.ordinal() < other.ordinal();
    }

    public int getAirAmountAfterProtection(LivingEntity entity) {
        return this.isProtected(entity) ? 0 : this.getAirAmount(entity);
    }

    boolean isProtected(LivingEntity entity) {
        return MobEffectUtil.hasWaterBreathing((LivingEntity)entity) || entity.isUsingItem() && entity.getUseItem().is(ThickAir.AIR_REFILLER_ITEM_TAG) || this.isProtectedViaBreathingEquipment(entity);
    }

    int getAirAmount(LivingEntity entity) {
        Level level = entity.level();
        int respirationLevel = EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.RESPIRATION), (LivingEntity)entity);
        return entity.getRandom().nextInt(respirationLevel + 1) == 0 ? -1 : 0;
    }

    private boolean isProtectedViaBreathingEquipment(LivingEntity entity) {
        if (this.breathingEquipment != null) {
            ItemStack itemStack = AirQualityLevel.findEquippedItem(entity, this.breathingEquipment);
            if (!itemStack.isEmpty() && entity.level().getGameTime() % 300L == 0L) {
                itemStack.hurtAndBreak(1, entity, EquipmentSlot.HEAD);
            }
            return !itemStack.isEmpty();
        }
        return false;
    }

    private static ItemStack findEquippedItem(LivingEntity entity, TagKey<Item> tag) {
        ItemStack helmet = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.is(tag)) {
            return helmet;
        }
        return CuriosCompat.findEquippedItem(entity, tag);
    }

    public float getItemModelProperty() {
        return (float)this.ordinal() / 10.0f;
    }

    @Nullable
    public static AirQualityLevel getAirQualityAtEyes(BlockState blockState) {
        if (blockState.is(Blocks.BUBBLE_COLUMN)) {
            return GREEN;
        }
        if (!blockState.getFluidState().isEmpty()) {
            return RED;
        }
        return AirQualityLevel.getAirQualityFromBlock(blockState);
    }

    @Nullable
    public static AirQualityLevel getAirQualityFromBlock(BlockState blockState) {
        if (blockState.hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return null;
        }
        for (AirQualityLevel airQualityLevel : AirQualityLevel.values()) {
            if (!blockState.is(airQualityLevel.airProviders)) continue;
            return airQualityLevel;
        }
        return null;
    }

    static {
        CODEC = StringRepresentable.fromEnum(AirQualityLevel::values);
    }
}

