/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.block;

import com.leclowndu93150.thick_air.api.AirQualityHelper;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class SafetyLanternBlock
extends LanternBlock {
    public static final MapCodec<SafetyLanternBlock> CODEC = SafetyLanternBlock.simpleCodec(SafetyLanternBlock::new);
    public static final EnumProperty<AirQualityLevel> AIR_QUALITY = EnumProperty.create((String)"air_quality", AirQualityLevel.class);
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;

    public SafetyLanternBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AIR_QUALITY, (Comparable)((Object)AirQualityLevel.GREEN))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<LanternBlock> codec() {
        return CODEC;
    }

    private static BlockState setAirQuality(Level level, BlockPos pos, BlockState blockState) {
        return (BlockState)blockState.setValue(AIR_QUALITY, (Comparable)((Object)AirQualityHelper.getAirQualityAtLocation(level, Vec3.atCenterOf((Vec3i)pos))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AIR_QUALITY, LOCKED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        blockState = SafetyLanternBlock.setAirQuality(context.getLevel(), context.getClickedPos(), blockState);
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState out;
            if (direction.getAxis() != Direction.Axis.Y || !(out = (BlockState)blockState.setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return out;
        }
        return null;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.scheduleTick(pos, (Block)this, 20, TickPriority.NORMAL);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemUsed, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        AirQualityLevel lockedAirQuality = null;
        AirQualityLevel presentLockedAirQuality = null;
        boolean strippedDye = false;
        if (((Boolean)blockState.getValue((Property)LOCKED)).booleanValue()) {
            presentLockedAirQuality = (AirQualityLevel)((Object)blockState.getValue(AIR_QUALITY));
        }
        if (itemUsed.is(Items.GREEN_DYE) && presentLockedAirQuality != AirQualityLevel.GREEN) {
            lockedAirQuality = AirQualityLevel.GREEN;
        } else if (itemUsed.is(Items.BLUE_DYE) && presentLockedAirQuality != AirQualityLevel.BLUE) {
            lockedAirQuality = AirQualityLevel.BLUE;
        } else if (itemUsed.is(Items.YELLOW_DYE) && presentLockedAirQuality != AirQualityLevel.YELLOW) {
            lockedAirQuality = AirQualityLevel.YELLOW;
        } else if (itemUsed.is(Items.RED_DYE) && presentLockedAirQuality != AirQualityLevel.RED) {
            lockedAirQuality = AirQualityLevel.RED;
        } else if (itemUsed.getItem() instanceof AxeItem && ((Boolean)blockState.getValue((Property)LOCKED)).booleanValue()) {
            strippedDye = true;
        }
        boolean didAnything = false;
        BlockState newBs = blockState;
        if (lockedAirQuality != null) {
            newBs = (BlockState)((BlockState)newBs.setValue(AIR_QUALITY, (Comparable)((Object)lockedAirQuality))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(true));
            level.levelEvent(player, 3003, pos, 0);
            if (!player.getAbilities().instabuild) {
                itemUsed.shrink(1);
            }
            didAnything = true;
        } else if (strippedDye) {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, pos, 0);
            itemUsed.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            player.swing(hand);
            newBs = (BlockState)newBs.setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false));
            newBs = SafetyLanternBlock.setAirQuality(level, pos, newBs);
            didAnything = true;
        }
        level.setBlockAndUpdate(pos, newBs);
        if (didAnything) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        serverLevel.scheduleTick(blockPos, (Block)this, 20, TickPriority.NORMAL);
        if (!((Boolean)blockState.getValue((Property)LOCKED)).booleanValue()) {
            serverLevel.setBlockAndUpdate(blockPos, SafetyLanternBlock.setAirQuality((Level)serverLevel, blockPos, blockState));
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return ((AirQualityLevel)((Object)blockState.getValue(AIR_QUALITY))).getOutputSignal();
    }
}

