/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.block;

import com.leclowndu93150.thick_air.Config;
import com.leclowndu93150.thick_air.ModRegistry;
import com.leclowndu93150.thick_air.advancement.SignalifyTorchTrigger;
import com.leclowndu93150.thick_air.block.WallSignalTorchBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class SignalTorchBlock
extends TorchBlock {
    public static final MapCodec<SignalTorchBlock> CODEC = SignalTorchBlock.simpleCodec(SignalTorchBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public SignalTorchBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public MapCodec<? extends TorchBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.7;
            double z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            if (random.nextInt(3) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, x, y + 0.5, z, random.nextGaussian() * 0.05, random.nextDouble() * 0.05, random.nextGaussian() * 0.05);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!Config.enableSignalTorches) {
            return InteractionResult.PASS;
        }
        boolean newLit = (Boolean)state.getValue((Property)LIT) == false;
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(newLit)));
        level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((SignalifyTorchTrigger)((Object)ModRegistry.SIGNALIFY_TORCH_TRIGGER.get())).trigger(serverPlayer);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!Config.enableSignalTorches) {
            return;
        }
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty()) {
            return;
        }
        if (state.is(Blocks.TORCH)) {
            level.setBlockAndUpdate(pos, ((SignalTorchBlock)((Object)ModRegistry.SIGNAL_TORCH_BLOCK.get())).defaultBlockState());
            level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((SignalifyTorchTrigger)((Object)ModRegistry.SIGNALIFY_TORCH_TRIGGER.get())).trigger(serverPlayer);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
        } else if (state.is(Blocks.WALL_TORCH)) {
            BlockState signalState = (BlockState)((WallSignalTorchBlock)((Object)ModRegistry.WALL_SIGNAL_TORCH_BLOCK.get())).defaultBlockState().setValue((Property)WallSignalTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING)));
            level.setBlockAndUpdate(pos, signalState);
            level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((SignalifyTorchTrigger)((Object)ModRegistry.SIGNALIFY_TORCH_TRIGGER.get())).trigger(serverPlayer);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }
}

