/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.capability;

import com.leclowndu93150.thick_air.api.AirQualityLevel;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;

public class AirBubblePositions {
    private static final Codec<AirQualityLevel> AIR_QUALITY_CODEC = Codec.STRING.xmap(s -> AirQualityLevel.valueOf(s.toUpperCase()), AirQualityLevel::getSerializedName);
    public static final Codec<AirBubblePositions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(Entry.CODEC).fieldOf("entries").forGetter(AirBubblePositions::toEntryList), (App)Codec.INT.optionalFieldOf("skipCountLeft", (Object)0).forGetter(cap -> cap.skipCountLeft)).apply((Applicative)instance, AirBubblePositions::fromEntryList));
    private int skipCountLeft;
    private Map<BlockPos, AirQualityLevel> airBubbleEntries = new LinkedHashMap<BlockPos, AirQualityLevel>();

    private static AirBubblePositions fromEntryList(List<Entry> entries, int skipCountLeft) {
        AirBubblePositions cap = new AirBubblePositions();
        cap.skipCountLeft = skipCountLeft;
        for (Entry entry : entries) {
            cap.airBubbleEntries.put(entry.pos, entry.quality);
        }
        return cap;
    }

    private List<Entry> toEntryList() {
        return this.airBubbleEntries.entrySet().stream().map(e -> new Entry((BlockPos)e.getKey(), (AirQualityLevel)((Object)((Object)e.getValue())))).toList();
    }

    public Map<BlockPos, AirQualityLevel> getAirBubblePositionsView() {
        return Collections.unmodifiableMap(this.airBubbleEntries);
    }

    public Map<BlockPos, AirQualityLevel> getAirBubblePositions() {
        return this.airBubbleEntries;
    }

    public int getSkipCountLeft() {
        return this.skipCountLeft;
    }

    public void setSkipCountLeft(int skipCountLeft) {
        this.skipCountLeft = skipCountLeft;
    }

    private record Entry(BlockPos pos, AirQualityLevel quality) {
        static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(Entry::pos), (App)AIR_QUALITY_CODEC.fieldOf("quality").forGetter(Entry::quality)).apply((Applicative)instance, Entry::new));
    }
}

