/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.client;

import com.leclowndu93150.thick_air.ModRegistry;
import com.leclowndu93150.thick_air.ThickAir;
import com.leclowndu93150.thick_air.api.AirQualityHelper;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import com.leclowndu93150.thick_air.block.SafetyLanternBlock;
import com.leclowndu93150.thick_air.client.RespiratorArmorLayer;
import com.leclowndu93150.thick_air.client.RespiratorRenderer;
import com.leclowndu93150.thick_air.compat.CuriosClientCompat;
import com.leclowndu93150.thick_air.compat.CuriosCompat;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="thick_air", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ThickAirClient {
    public static final ResourceLocation AIR_QUALITY_LEVEL_PROPERTY = ThickAir.id("air_quality_level");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModRegistry.SAFETY_LANTERN_ITEM.get()), (ResourceLocation)AIR_QUALITY_LEVEL_PROPERTY, (stack, level, entity, seed) -> {
                Entity patt0$temp;
                BlockItemStateProperties blockState;
                if (stack.has(DataComponents.BLOCK_STATE) && (blockState = (BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE)) != null) {
                    Map props = blockState.properties();
                    for (Map.Entry entry : props.entrySet()) {
                        if (!((String)entry.getKey()).equals(SafetyLanternBlock.AIR_QUALITY.getName())) continue;
                        String value = (String)entry.getValue();
                        try {
                            AirQualityLevel airQuality = AirQualityLevel.valueOf(value.toUpperCase());
                            return airQuality.getItemModelProperty();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                if (entity == null && (patt0$temp = stack.getEntityRepresentation()) instanceof LivingEntity) {
                    LivingEntity livingEntity;
                    entity = livingEntity = (LivingEntity)patt0$temp;
                }
                AirQualityLevel airQualityAtLocation = entity != null ? AirQualityHelper.getAirQualityAtLocation(entity) : AirQualityLevel.YELLOW;
                return airQualityAtLocation.getItemModelProperty();
            });
            if (CuriosCompat.isCuriosLoaded()) {
                CuriosClientCompat.registerCuriosRenderer();
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RespiratorRenderer.PLAYER_RESPIRATOR_LAYER, RespiratorRenderer::createLayerDefinition);
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        RespiratorRenderer.bakeModel(Minecraft.getInstance().getEntityModels());
        for (PlayerSkin.Model skin : event.getSkins()) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(skin);
            if (renderer == null) continue;
            renderer.addLayer(new RespiratorArmorLayer(renderer));
        }
    }
}

