/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.compat;

import com.leclowndu93150.thick_air.ModRegistry;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    private static final boolean CURIOS_LOADED = ModList.get().isLoaded("curios");

    public static ItemStack findEquippedItem(LivingEntity entity, TagKey<Item> tag) {
        if (!CURIOS_LOADED) {
            return ItemStack.EMPTY;
        }
        return CuriosCompat.findEquippedItemCurios(entity, tag);
    }

    private static ItemStack findEquippedItemCurios(LivingEntity entity, TagKey<Item> tag) {
        Optional<ItemStack> result = CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(inv -> inv.findFirstCurio(stack -> stack.is(tag)));
        return result.map(SlotResult::stack).orElse(ItemStack.EMPTY);
    }

    public static boolean isCuriosLoaded() {
        return CURIOS_LOADED;
    }

    public static void registerCapabilities(IEventBus modEventBus) {
        if (!CURIOS_LOADED) {
            return;
        }
        modEventBus.addListener(event -> event.registerItem(CuriosCapability.ITEM, (stack, context) -> new ICurio((ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
            }

            public ItemStack getStack() {
                return this.val$stack;
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }
        }, new ItemLike[]{(ItemLike)ModRegistry.RESPIRATOR_ITEM.get()}));
    }
}

