/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.handler;

import com.leclowndu93150.thick_air.ModRegistry;
import com.leclowndu93150.thick_air.ThickAir;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import com.leclowndu93150.thick_air.capability.AirBubblePositions;
import com.leclowndu93150.thick_air.network.ChunkAirQualityPayload;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AirBubbleTracker {
    private static final Set<ChunkPos> CHUNKS_TO_SCAN = ConcurrentHashMap.newKeySet();
    private static final List<Map.Entry<ChunkPos, BlockPos>> CHUNK_SCANNING_PROGRESS = Collections.synchronizedList(new LinkedList());

    public static void onBlockStateChange(ServerLevel level, BlockPos pos, BlockState oldBlockState, BlockState newBlockState) {
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk chunk = level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
        if (chunk != null && !oldBlockState.is(newBlockState.getBlock())) {
            AirQualityLevel airQualityLevel;
            AirBubblePositions capability = (AirBubblePositions)chunk.getData(ModRegistry.AIR_BUBBLE_POSITIONS);
            if (AirQualityLevel.getAirQualityFromBlock(oldBlockState) != null) {
                AirQualityLevel removed = capability.getAirBubblePositions().remove(pos);
                if (removed == null) {
                    ThickAir.LOGGER.debug("Didn't remove any air bubbles at {}", (Object)pos);
                } else {
                    chunk.setUnsaved(true);
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new ChunkAirQualityPayload(chunkPos, Map.of(pos, removed), ChunkAirQualityPayload.Mode.REMOVE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if ((airQualityLevel = AirQualityLevel.getAirQualityFromBlock(newBlockState)) != null) {
                AirQualityLevel clobbered = capability.getAirBubblePositions().put(pos, airQualityLevel);
                if (clobbered != null) {
                    ThickAir.LOGGER.debug("Clobbered air bubble at {}: {}", (Object)pos, (Object)clobbered);
                }
                chunk.setUnsaved(true);
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new ChunkAirQualityPayload(chunkPos, Map.of(pos, airQualityLevel), ChunkAirQualityPayload.Mode.ADD), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess;
        if (event.getLevel() instanceof ServerLevel && (chunkAccess = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            CHUNKS_TO_SCAN.add(chunk.getPos());
            CHUNK_SCANNING_PROGRESS.add(Map.entry(chunk.getPos(), AirBubbleTracker.getChunkStartingPosition(chunk)));
        }
    }

    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess;
        if (event.getLevel() instanceof ServerLevel && (chunkAccess = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            CHUNKS_TO_SCAN.remove(chunk.getPos());
        }
    }

    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerPlayer player = event.getPlayer();
        LevelChunk chunk = event.getChunk();
        AirBubblePositions capability = (AirBubblePositions)chunk.getData(ModRegistry.AIR_BUBBLE_POSITIONS);
        Map<BlockPos, AirQualityLevel> airBubblePositions = capability.getAirBubblePositionsView();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ChunkAirQualityPayload(chunk.getPos(), airBubblePositions, ChunkAirQualityPayload.Mode.REPLACE), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            CHUNKS_TO_SCAN.clear();
            CHUNK_SCANNING_PROGRESS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onLevelTick(LevelTickEvent.Post event) {
        Object object = event.getLevel();
        if (!(object instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)object;
        if (!CHUNK_SCANNING_PROGRESS.isEmpty()) {
            object = CHUNK_SCANNING_PROGRESS;
            synchronized (object) {
                if (CHUNK_SCANNING_PROGRESS.isEmpty()) {
                    return;
                }
                ListIterator<Map.Entry<ChunkPos, BlockPos>> iterator = CHUNK_SCANNING_PROGRESS.listIterator();
                Map.Entry<ChunkPos, BlockPos> entry = iterator.next();
                ChunkPos chunkPos = entry.getKey();
                if (CHUNKS_TO_SCAN.contains(chunkPos)) {
                    LevelChunk chunk = level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
                    if (chunk != null) {
                        AirBubblePositions capability = (AirBubblePositions)chunk.getData(ModRegistry.AIR_BUBBLE_POSITIONS);
                        capability.setSkipCountLeft(8);
                        HashMap<BlockPos, AirQualityLevel> airBubblePositions = new HashMap<BlockPos, AirQualityLevel>();
                        BlockPos blockPos = AirBubbleTracker.collectAirQualityPositions(chunk, entry.getValue(), airBubblePositions);
                        boolean markDirty = false;
                        if (entry.getValue().equals((Object)AirBubbleTracker.getChunkStartingPosition(chunk))) {
                            capability.getAirBubblePositions().clear();
                            capability.getAirBubblePositions().putAll(airBubblePositions);
                            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new ChunkAirQualityPayload(chunkPos, airBubblePositions, ChunkAirQualityPayload.Mode.REPLACE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            markDirty = true;
                        } else if (!airBubblePositions.isEmpty()) {
                            capability.getAirBubblePositions().putAll(airBubblePositions);
                            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new ChunkAirQualityPayload(chunkPos, airBubblePositions, ChunkAirQualityPayload.Mode.ADD), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            markDirty = true;
                        }
                        if (markDirty) {
                            chunk.setUnsaved(true);
                        }
                        if (blockPos != null) {
                            iterator.set(Map.entry(chunkPos, blockPos));
                            return;
                        }
                    } else {
                        return;
                    }
                }
                iterator.remove();
                CHUNKS_TO_SCAN.remove(chunkPos);
            }
        }
    }

    private static BlockPos getChunkStartingPosition(LevelChunk chunk) {
        int posX = chunk.getPos().getMinBlockX();
        int posY = chunk.getMinBuildHeight();
        int posZ = chunk.getPos().getMinBlockZ();
        return new BlockPos(posX, posY, posZ);
    }

    @Nullable
    private static BlockPos collectAirQualityPositions(LevelChunk chunk, BlockPos startingPosition, Map<BlockPos, AirQualityLevel> airBubbleEntries) {
        int minX = chunk.getPos().getMinBlockX();
        int minY = chunk.getMinBuildHeight();
        int minZ = chunk.getPos().getMinBlockZ();
        int startX = startingPosition.getX() - minX;
        int startY = startingPosition.getY();
        int startZ = startingPosition.getZ() - minZ;
        int iterations = 0;
        for (int dx = startX; dx < 16; ++dx) {
            for (int dz = startZ; dz < 16; ++dz) {
                int posX = minX + dx;
                int posZ = minZ + dz;
                int maxY = chunk.getLevel().getHeight(Heightmap.Types.WORLD_SURFACE, posX, posZ);
                int posY = startY;
                while (posY < maxY) {
                    BlockPos blockPos = new BlockPos(posX, posY, posZ);
                    if (iterations >= 98304) {
                        return blockPos;
                    }
                    BlockState blockState = chunk.getBlockState(blockPos);
                    AirQualityLevel airQualityLevel = AirQualityLevel.getAirQualityFromBlock(blockState);
                    if (airQualityLevel != null) {
                        airBubbleEntries.put(blockPos, airQualityLevel);
                    }
                    ++posY;
                    startY = minY;
                    ++iterations;
                }
                startZ = 0;
            }
            startX = 0;
        }
        return null;
    }
}

