/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.item;

import com.leclowndu93150.thick_air.api.AirQualityHelper;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class AirBladderItem
extends Item {
    public AirBladderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        boolean canProvideAir;
        AirQualityLevel airQualityLevel = AirQualityHelper.getAirQualityAtLocation((LivingEntity)player);
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        boolean canRefill = airQualityLevel.canRefillAir && itemInHand.isDamaged();
        boolean bl = canProvideAir = !airQualityLevel.canRefillAir && itemInHand.getDamageValue() < itemInHand.getMaxDamage() && player.getAirSupply() < player.getMaxAirSupply();
        if (canRefill || canProvideAir) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
        }
        return super.use(level, player, interactionHand);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack itemStack, int remainingUseDuration) {
        boolean stopUsing = true;
        AirQualityLevel airQualityLevel = AirQualityHelper.getAirQualityAtLocation(entity);
        if (airQualityLevel.canRefillAir) {
            if (itemStack.isDamaged()) {
                itemStack.setDamageValue(itemStack.getDamageValue() - 4);
                stopUsing = false;
            }
        } else if (itemStack.getDamageValue() < itemStack.getMaxDamage()) {
            int i = 4;
            while (i-- > 0 && entity.getAirSupply() < entity.getMaxAirSupply() && itemStack.getDamageValue() < itemStack.getMaxDamage()) {
                entity.setAirSupply(entity.getAirSupply() + 1);
                itemStack.setDamageValue(itemStack.getDamageValue() + 1);
                stopUsing = false;
            }
        }
        if (!stopUsing) {
            if (remainingUseDuration <= this.getUseDuration(itemStack, entity) - 7 && remainingUseDuration % 4 == 0) {
                entity.playSound(this.getDrinkingSound(), 0.5f, entity.level().random.nextFloat() * 0.1f + 0.9f);
            }
        } else {
            entity.releaseUsingItem();
        }
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int timeCharged) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getAirSupply() >= player.getMaxAirSupply() && !AirQualityHelper.getAirQualityAtLocation((LivingEntity)livingEntity).canRefillAir) {
            player.getCooldowns().addCooldown((Item)this, 150);
        }
        super.releaseUsing(itemStack, level, livingEntity, timeCharged);
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.GENERIC_DRINK;
    }
}

