/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.thick_air.network;

import com.leclowndu93150.thick_air.ModRegistry;
import com.leclowndu93150.thick_air.ThickAir;
import com.leclowndu93150.thick_air.api.AirQualityLevel;
import com.leclowndu93150.thick_air.capability.AirBubblePositions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChunkAirQualityPayload(ChunkPos chunkPos, Map<BlockPos, AirQualityLevel> airBubblePositions, Mode mode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChunkAirQualityPayload> TYPE = new CustomPacketPayload.Type(ThickAir.id("chunk_air_quality"));
    public static final StreamCodec<FriendlyByteBuf, ChunkAirQualityPayload> STREAM_CODEC = StreamCodec.of(ChunkAirQualityPayload::encode, ChunkAirQualityPayload::decode);

    private static void encode(FriendlyByteBuf buf, ChunkAirQualityPayload payload) {
        buf.writeLong(payload.chunkPos.toLong());
        buf.writeVarInt(payload.airBubblePositions.size());
        for (Map.Entry<BlockPos, AirQualityLevel> entry : payload.airBubblePositions.entrySet()) {
            buf.writeBlockPos(entry.getKey());
            buf.writeByte(entry.getValue().ordinal());
        }
        buf.writeEnum((Enum)payload.mode);
    }

    private static ChunkAirQualityPayload decode(FriendlyByteBuf buf) {
        ChunkPos chunkPos = new ChunkPos(buf.readLong());
        int size = buf.readVarInt();
        HashMap<BlockPos, AirQualityLevel> positions = new HashMap<BlockPos, AirQualityLevel>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.readBlockPos();
            AirQualityLevel quality = AirQualityLevel.values()[buf.readByte()];
            positions.put(pos, quality);
        }
        Mode mode = (Mode)buf.readEnum(Mode.class);
        return new ChunkAirQualityPayload(chunkPos, positions, mode);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(ChunkAirQualityPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            LevelChunk chunk;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && mc.level.getChunkSource().hasChunk(payload.chunkPos.x, payload.chunkPos.z) && (chunk = mc.level.getChunkSource().getChunkNow(payload.chunkPos.x, payload.chunkPos.z)) != null) {
                AirBubblePositions capability = (AirBubblePositions)chunk.getData(ModRegistry.AIR_BUBBLE_POSITIONS);
                Map<BlockPos, AirQualityLevel> airBubblePositions = capability.getAirBubblePositions();
                switch (payload.mode.ordinal()) {
                    case 0: {
                        airBubblePositions.clear();
                        airBubblePositions.putAll(payload.airBubblePositions);
                        break;
                    }
                    case 2: {
                        airBubblePositions.putAll(payload.airBubblePositions);
                        break;
                    }
                    case 1: {
                        payload.airBubblePositions.keySet().forEach(airBubblePositions::remove);
                    }
                }
            }
        });
    }

    public static enum Mode {
        REPLACE,
        REMOVE,
        ADD;

    }
}

