/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.core.Ownable;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public record MinecartPredicate(Optional<Boolean> highSpeed, Optional<Boolean> launched, Optional<Boolean> onElevator, Optional<Boolean> derailed, Optional<Boolean> mountable, Optional<Boolean> checksOwner, MinMaxBounds.Doubles speed, Optional<EntityPredicate> parent) {
    public static final Codec<MinecartPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("highSpeed").forGetter(MinecartPredicate::highSpeed), (App)Codec.BOOL.optionalFieldOf("launched").forGetter(MinecartPredicate::launched), (App)Codec.BOOL.optionalFieldOf("onElevator").forGetter(MinecartPredicate::onElevator), (App)Codec.BOOL.optionalFieldOf("derailed").forGetter(MinecartPredicate::derailed), (App)Codec.BOOL.optionalFieldOf("mountable").forGetter(MinecartPredicate::mountable), (App)Codec.BOOL.optionalFieldOf("checksOwner").forGetter(MinecartPredicate::checksOwner), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("speed", (Object)MinMaxBounds.Doubles.ANY).forGetter(MinecartPredicate::speed), (App)EntityPredicate.CODEC.optionalFieldOf("parent").forGetter(MinecartPredicate::parent)).apply((Applicative)instance, MinecartPredicate::new));

    public boolean matches(ServerPlayer player, AbstractMinecart cart) {
        Ownable ownable;
        RollingStock rollingStock = RollingStock.getOrThrow(cart);
        if (this.highSpeed.isPresent() && rollingStock.isHighSpeed() != this.highSpeed.get().booleanValue()) {
            return false;
        }
        if (this.launched.isPresent() && rollingStock.isLaunched() != this.launched.get().booleanValue()) {
            return false;
        }
        if (this.onElevator.isPresent() && rollingStock.isOnElevator() != this.onElevator.get().booleanValue()) {
            return false;
        }
        if (this.derailed.isPresent() && rollingStock.isDerailed() != this.derailed.get().booleanValue()) {
            return false;
        }
        if (this.mountable.isPresent() && rollingStock.isMountable() != this.mountable.get().booleanValue()) {
            return false;
        }
        if (this.checksOwner.isPresent() && cart instanceof Ownable && (ownable = (Ownable)cart).getOwner().map(owner -> !owner.equals((Object)player.getGameProfile())).orElse(false).booleanValue()) {
            return false;
        }
        if (!this.speed.matchesSqr(MinecartUtil.getCartSpeedUncappedSquared(cart.getDeltaMovement()))) {
            return false;
        }
        return this.parent.map(x -> x.matches(player, (Entity)cart)).orElse(true);
    }
}

