/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.container.manipulator;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ItemHandlerSlotAccessor<T extends ResourceHandler<ItemResource>>
implements SlotAccessor {
    protected final T itemHandler;
    protected final int index;

    private ItemHandlerSlotAccessor(T itemHandler, int index) {
        this.itemHandler = itemHandler;
        this.index = index;
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return this.itemHandler.isValid(this.index, (Resource)ItemResource.of((ItemStack)stack));
    }

    @Override
    public ItemStack extract(int amount, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            ItemResource resource = (ItemResource)this.itemHandler.getResource(this.index);
            if (resource.isEmpty()) {
                ItemStack itemStack = ItemStack.EMPTY;
                return itemStack;
            }
            int extracted = this.itemHandler.extract(this.index, (Resource)resource, amount, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = resource.toStack(extracted);
            return itemStack;
        }
    }

    @Override
    public ItemStack insert(ItemStack stack, boolean simulate) {
        return ItemUtil.insertItemReturnRemaining(this.itemHandler, (int)this.index, (ItemStack)stack, (boolean)simulate, null);
    }

    @Override
    public ItemStack item() {
        return ItemUtil.getStack(this.itemHandler, (int)this.index);
    }

    @Override
    public int maxStackSize() {
        return this.itemHandler.getCapacityAsInt(this.index, (Resource)ItemResource.EMPTY);
    }

    public static Stream<SlotAccessor> createSlots(ResourceHandler<ItemResource> itemHandler) {
        return IntStream.range(0, itemHandler.size()).mapToObj(i -> new ItemHandlerSlotAccessor<ResourceHandler>(itemHandler, i));
    }
}

