/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.track;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import mods.railcraft.api.core.RailcraftFakePlayer;
import mods.railcraft.api.item.TrackPlacer;
import mods.railcraft.api.item.TrackTypeLike;
import mods.railcraft.api.track.LockingTrack;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public final class TrackUtil {
    private TrackUtil() {
    }

    public static BlockState setShape(BaseRailBlock block, @Nullable RailShape trackShape) {
        Property property = block.getShapeProperty();
        BlockState state = block.defaultBlockState();
        if (trackShape != null && property.getPossibleValues().contains(trackShape)) {
            state = (BlockState)state.setValue(property, (Comparable)trackShape);
        }
        return state;
    }

    public static boolean placeRailAt(ItemStack stack, ServerLevel level, BlockPos pos, RailShape railShape) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof TrackPlacer) {
            TrackPlacer placer = (TrackPlacer)item;
            return placer.placeTrack(stack.copy(), (Player)RailcraftFakePlayer.get(level, pos.relative(Direction.UP)), (Level)level, pos, railShape);
        }
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && (item2 = (blockItem = (BlockItem)item2).getBlock()) instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)item2;
            BlockState blockState = TrackUtil.setShape(railBlock, railShape);
            boolean success = level.setBlockAndUpdate(pos, blockState);
            if (success) {
                SoundType soundType = railBlock.getSoundType(blockState, (LevelReader)level, pos, null);
                level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
            return success;
        }
        return false;
    }

    public static boolean placeRailAt(ItemStack stack, ServerLevel level, BlockPos pos) {
        return TrackUtil.placeRailAt(stack, level, pos, RailShape.NORTH_SOUTH);
    }

    public static boolean isTrackItem(@Nullable ItemStack stack) {
        return stack != null && stack.getItem() instanceof TrackPlacer;
    }

    public static boolean isCartLocked(AbstractMinecart cart) {
        LockingTrack lockingTrack;
        BlockState blockState;
        Block block;
        BlockPos pos = cart.blockPosition();
        if (BaseRailBlock.isRail((Level)cart.level(), (BlockPos)pos.below())) {
            pos = pos.below();
        }
        return (block = (blockState = cart.level().getBlockState(pos)).getBlock()) instanceof LockingTrack && (lockingTrack = (LockingTrack)block).isCartLocked(cart);
    }

    public static int countAdjacentTracks(Level level, BlockPos pos) {
        return (int)Direction.Plane.HORIZONTAL.stream().filter(side -> TrackUtil.isTrackFuzzyAt(level, pos.relative(side))).count();
    }

    public static boolean isTrackFuzzyAt(Level level, BlockPos pos) {
        return BaseRailBlock.isRail((Level)level, (BlockPos)pos) || BaseRailBlock.isRail((Level)level, (BlockPos)pos.above()) || BaseRailBlock.isRail((Level)level, (BlockPos)pos.below());
    }

    @Nullable
    public static TrackType getTrackType(ItemStack stack) {
        TrackType trackType;
        Item item = stack.getItem();
        if (item instanceof TrackTypeLike) {
            TrackTypeLike trackTypeLike = (TrackTypeLike)item;
            trackType = trackTypeLike.getTrackType(stack);
        } else {
            trackType = null;
        }
        return trackType;
    }

    public static boolean isStraightTrackAt(BlockGetter level, BlockPos pos) {
        return BaseRailBlock.isRail((BlockState)level.getBlockState(pos)) && !RailShapeUtil.isTurn(TrackUtil.getTrackDirection(level, pos));
    }

    public static boolean isRail(ItemStack stack) {
        return TrackUtil.isRail(stack.getItem());
    }

    public static boolean isRail(Item item) {
        BlockItem blockItem;
        return item instanceof TrackPlacer || item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof BaseRailBlock && blockItem.getBlock().builtInRegistryHolder().is(BlockTags.RAILS);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos, BlockState state) {
        return TrackUtil.getTrackDirection(level, pos, state, null);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos) {
        return TrackUtil.getTrackDirection(level, pos, (AbstractMinecart)null);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos, @Nullable AbstractMinecart cart) {
        return TrackUtil.getTrackDirection(level, pos, level.getBlockState(pos), cart);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos, BlockState state, @Nullable AbstractMinecart cart) {
        return TrackUtil.asRailBlock(state.getBlock()).getRailDirection(state, level, pos, cart);
    }

    public static RailShape getRailShapeRaw(BlockGetter level, BlockPos pos) {
        return TrackUtil.getRailShapeRaw(level.getBlockState(pos));
    }

    public static RailShape getRailShapeRaw(BlockState blockState) {
        return (RailShape)blockState.getValue(TrackUtil.getRailShapeProperty(blockState.getBlock()));
    }

    public static Property<RailShape> getRailShapeProperty(Block block) {
        return TrackUtil.asRailBlock(block).getShapeProperty();
    }

    public static BaseRailBlock asRailBlock(Block block) {
        if (block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            return railBlock;
        }
        throw new IllegalArgumentException("%s is not a rail block.".formatted(BuiltInRegistries.BLOCK.getKey((Object)block)));
    }

    public static boolean setRailShape(Level level, BlockPos pos, RailShape railShape) {
        BlockState blockState = level.getBlockState(pos);
        Property<RailShape> prop = TrackUtil.getRailShapeProperty(blockState.getBlock());
        if (!prop.getPossibleValues().contains(railShape)) {
            return false;
        }
        blockState = (BlockState)blockState.setValue(prop, (Comparable)railShape);
        return level.setBlockAndUpdate(pos, blockState);
    }

    public static void updateDir(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            railBlock.updateDir(level, pos, state, false);
        }
    }

    public static void traverseConnectedTracks(Level level, BlockPos pos, BiFunction<Level, BlockPos, Boolean> action) {
        TrackUtil.traverseConnectedTracks(level, pos, action, new HashSet<BlockPos>());
    }

    private static void traverseConnectedTracks(Level level, BlockPos pos, BiFunction<Level, BlockPos, Boolean> action, Set<BlockPos> visited) {
        visited.add(pos);
        if (!action.apply(level, pos).booleanValue()) {
            return;
        }
        TrackUtil.getConnectedTracks((LevelReader)level, pos).stream().filter(p -> !visited.contains(p)).forEach(p -> TrackUtil.traverseConnectedTracks(level, p, action, visited));
    }

    public static Set<BlockPos> getConnectedTracks(LevelReader level, BlockPos pos) {
        RailShape shape = BaseRailBlock.isRail((BlockState)level.getBlockState(pos)) ? TrackUtil.getRailShapeRaw((BlockGetter)level, pos) : RailShape.NORTH_SOUTH;
        return Direction.Plane.HORIZONTAL.stream().flatMap(side -> TrackUtil.getTrackConnectedTrackAt(level, pos.relative(side), shape).stream()).collect(Collectors.toSet());
    }

    public static Optional<BlockPos> getTrackConnectedTrackAt(LevelReader level, BlockPos pos, RailShape shape) {
        if (BaseRailBlock.isRail((BlockState)level.getBlockState(pos))) {
            return Optional.of(pos);
        }
        BlockPos up = pos.above();
        if (shape.isSlope() && BaseRailBlock.isRail((BlockState)level.getBlockState(up))) {
            return Optional.of(up);
        }
        BlockPos down = pos.below();
        if (BaseRailBlock.isRail((BlockState)level.getBlockState(down)) && TrackUtil.getRailShapeRaw((BlockGetter)level, down).isSlope()) {
            return Optional.of(down);
        }
        return Optional.empty();
    }

    public static RailShape getAxisAlignedDirection(Direction.Axis axis) {
        return switch (axis) {
            case Direction.Axis.X -> RailShape.EAST_WEST;
            case Direction.Axis.Z -> RailShape.NORTH_SOUTH;
            default -> throw new IllegalArgumentException("No corresponding direction for other axes.");
        };
    }

    public static RailShape getAxisAlignedDirection(Direction facing) {
        return TrackUtil.getAxisAlignedDirection(facing.getAxis());
    }

    public static Optional<Direction> getSideFacingTrack(Level level, BlockPos pos) {
        return Arrays.stream(Direction.values()).filter(dir -> BaseRailBlock.isRail((Level)level, (BlockPos)pos.relative(dir))).findFirst();
    }
}

