/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import java.util.Optional;
import java.util.Random;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeCartStorage;
import mods.railcraft.world.entity.vehicle.EnergyMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.energy.SimpleEnergyHandler;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ChargeCartStorageImpl
extends SimpleEnergyHandler
implements ChargeCartStorage {
    protected static final Random RANDOM = new Random();
    private static final int DRAW_INTERVAL = 8;
    protected final int lossPerTick;
    protected double draw;
    protected double chargeDrawnThisTick;
    protected int drewFromTrack;
    protected int clock = RANDOM.nextInt(0, 8);
    private final ChargeDrawnThisTickJournal chargeDrawnThisTickJournal = new ChargeDrawnThisTickJournal();

    public ChargeCartStorageImpl(int capacity) {
        this(capacity, 0);
    }

    public ChargeCartStorageImpl(int capacity, int lossPerTick) {
        super(capacity);
        this.lossPerTick = lossPerTick;
    }

    @Override
    public double getLosses() {
        return this.lossPerTick;
    }

    @Override
    public double getDraw() {
        return this.draw;
    }

    protected void removeLosses() {
        if (this.lossPerTick > 0) {
            this.energy = this.energy >= this.lossPerTick ? (this.energy -= this.lossPerTick) : 0;
        }
    }

    @Override
    public void tick(ServerLevel level, AbstractMinecart owner) {
        ++this.clock;
        this.removeLosses();
        this.draw = (this.draw * 24.0 + this.chargeDrawnThisTick) / 25.0;
        this.chargeDrawnThisTick = 0.0;
        if (this.drewFromTrack > 0) {
            --this.drewFromTrack;
        } else if ((double)this.energy < (double)this.capacity * 0.5 && this.clock % 8 == 0) {
            RollingStock.getOrThrow(owner).train().entities().filter(x -> x instanceof EnergyMinecart).flatMap(c -> Optional.ofNullable((EnergyHandler)c.getCapability(Capabilities.Energy.ENTITY, null)).stream()).findAny().ifPresent(energyStorage -> {
                try (Transaction tx = Transaction.openRoot();){
                    this.energy += energyStorage.extract(this.capacity - this.energy, (TransactionContext)tx);
                    tx.commit();
                }
            });
        }
    }

    @Override
    public void tickOnTrack(AbstractMinecart owner, BlockPos pos) {
        if (!owner.level().isClientSide() && this.needsCharging()) {
            int drawnFromTrack = Charge.distribution.network((ServerLevel)owner.level()).access(pos).removeCharge(this.capacity - this.energy, false);
            if (drawnFromTrack > 0) {
                this.drewFromTrack = 32;
            }
            this.energy += drawnFromTrack;
        }
    }

    public int extract(int amount, TransactionContext transaction) {
        int extracted = super.extract(amount, transaction);
        if (extracted > 0) {
            this.chargeDrawnThisTickJournal.updateSnapshots(transaction);
            this.chargeDrawnThisTick += (double)extracted;
        }
        return extracted;
    }

    private boolean needsCharging() {
        return this.energy < this.capacity;
    }

    private class ChargeDrawnThisTickJournal
    extends SnapshotJournal<Double> {
        private ChargeDrawnThisTickJournal() {
        }

        protected Double createSnapshot() {
            return ChargeCartStorageImpl.this.chargeDrawnThisTick;
        }

        protected void revertToSnapshot(Double snapshot) {
            ChargeCartStorageImpl.this.chargeDrawnThisTick = snapshot;
        }
    }
}

