/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import java.net.URI;
import java.net.URL;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalUtil;
import mods.railcraft.client.KeyBinding;
import mods.railcraft.client.RailcraftKeyMappingCategory;
import mods.railcraft.client.TuningAuraHandlerImpl;
import mods.railcraft.client.color.item.LocomotiveColor;
import mods.railcraft.client.gui.screen.inventory.BlastFurnaceScreen;
import mods.railcraft.client.gui.screen.inventory.CargoMinecartScreen;
import mods.railcraft.client.gui.screen.inventory.CartDispenserScreen;
import mods.railcraft.client.gui.screen.inventory.CokeOvenScreen;
import mods.railcraft.client.gui.screen.inventory.CreativeLocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.CrusherScreen;
import mods.railcraft.client.gui.screen.inventory.DumpingTrackScreen;
import mods.railcraft.client.gui.screen.inventory.ElectricLocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.EnergyMinecartScreen;
import mods.railcraft.client.gui.screen.inventory.FeedStationScreen;
import mods.railcraft.client.gui.screen.inventory.FluidFueledSteamBoilerScreen;
import mods.railcraft.client.gui.screen.inventory.FluidManipulatorScreen;
import mods.railcraft.client.gui.screen.inventory.ItemManipulatorScreen;
import mods.railcraft.client.gui.screen.inventory.ManualRollingMachineScreen;
import mods.railcraft.client.gui.screen.inventory.PoweredRollingMachineScreen;
import mods.railcraft.client.gui.screen.inventory.RoutingDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.RoutingTrackScreen;
import mods.railcraft.client.gui.screen.inventory.SolidFueledSteamBoilerScreen;
import mods.railcraft.client.gui.screen.inventory.SteamLocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.SteamOvenScreen;
import mods.railcraft.client.gui.screen.inventory.SteamTurbineScreen;
import mods.railcraft.client.gui.screen.inventory.SwitchTrackRouterScreen;
import mods.railcraft.client.gui.screen.inventory.TankMinecartScreen;
import mods.railcraft.client.gui.screen.inventory.TankScreen;
import mods.railcraft.client.gui.screen.inventory.TrackLayerScreen;
import mods.railcraft.client.gui.screen.inventory.TrackRelayerScreen;
import mods.railcraft.client.gui.screen.inventory.TrackUndercutterScreen;
import mods.railcraft.client.gui.screen.inventory.TrainDispenserScreen;
import mods.railcraft.client.gui.screen.inventory.TunnelBoreScreen;
import mods.railcraft.client.gui.screen.inventory.WaterTankSidingScreen;
import mods.railcraft.client.gui.screen.inventory.detector.AdvancedDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.ItemDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.LocomotiveDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.SheepDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.TankDetectorScreen;
import mods.railcraft.client.model.RailcraftLayerDefinitions;
import mods.railcraft.client.particle.ChimneyParticle;
import mods.railcraft.client.particle.ChunkLoaderParticle;
import mods.railcraft.client.particle.FireSparkParticle;
import mods.railcraft.client.particle.ForceSpawnParticle;
import mods.railcraft.client.particle.PumpkinParticle;
import mods.railcraft.client.particle.SparkParticle;
import mods.railcraft.client.particle.SteamParticle;
import mods.railcraft.client.particle.TuningAuraParticle;
import mods.railcraft.client.renderer.ShuntingAuraRenderer;
import mods.railcraft.client.renderer.blockentity.RailcraftBlockEntityRenderers;
import mods.railcraft.client.renderer.blockentity.VoidChestRenderer;
import mods.railcraft.client.renderer.entity.RailcraftEntityRenderers;
import mods.railcraft.client.renderer.item.VoidChestItemRenderer;
import mods.railcraft.integrations.jei.JeiRecipeSync;
import mods.railcraft.integrations.patchouli.Patchouli;
import mods.railcraft.network.to_server.SetLocomotiveByKeyMessage;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.GogglesItem;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import mods.railcraft.world.level.material.RailcraftFluidTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialBlockModelRendererEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class ClientManager {
    private static final ShuntingAuraRenderer shuntingAuraRenderer = new ShuntingAuraRenderer();

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(ClientManager::handleRegisterMenuScreens);
        modEventBus.addListener(ClientManager::handleClientSetup);
        modEventBus.addListener(ClientManager::registerItemTintSources);
        modEventBus.addListener(ClientManager::handleBlockColors);
        modEventBus.addListener(ClientManager::handleParticleRegistration);
        modEventBus.addListener(ClientManager::handleRegisterRenderers);
        modEventBus.addListener(ClientManager::handleRegisterLayerDefinitions);
        modEventBus.addListener(ClientManager::handleKeyRegister);
        modEventBus.addListener(ClientManager::handleClientExtensions);
        modEventBus.addListener(ClientManager::handleSpecialRenderers);
        modEventBus.addListener(ClientManager::handleSpecialBlockRenderers);
        NeoForge.EVENT_BUS.register(ClientManager.class);
        SignalUtil._setTuningAuraHandler(new TuningAuraHandlerImpl());
    }

    public static ShuntingAuraRenderer getShuntingAuraRenderer() {
        return shuntingAuraRenderer;
    }

    private static void handleRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)RailcraftMenuTypes.SOLID_FUELED_STEAM_BOILER.get(), SolidFueledSteamBoilerScreen::new);
        event.register((MenuType)RailcraftMenuTypes.FLUID_FUELED_STEAM_BOILER.get(), FluidFueledSteamBoilerScreen::new);
        event.register((MenuType)RailcraftMenuTypes.STEAM_TURBINE.get(), SteamTurbineScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TANK.get(), TankScreen::new);
        event.register((MenuType)RailcraftMenuTypes.WATER_TANK_SIDING.get(), WaterTankSidingScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TRACK_LAYER.get(), TrackLayerScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TRACK_RELAYER.get(), TrackRelayerScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TRACK_UNDERCUTTER.get(), TrackUndercutterScreen::new);
        event.register((MenuType)RailcraftMenuTypes.BLAST_FURNACE.get(), BlastFurnaceScreen::new);
        event.register((MenuType)RailcraftMenuTypes.FEED_STATION.get(), FeedStationScreen::new);
        event.register((MenuType)RailcraftMenuTypes.CREATIVE_LOCOMOTIVE.get(), CreativeLocomotiveScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ELECTRIC_LOCOMOTIVE.get(), ElectricLocomotiveScreen::new);
        event.register((MenuType)RailcraftMenuTypes.STEAM_LOCOMOTIVE.get(), SteamLocomotiveScreen::new);
        event.register((MenuType)RailcraftMenuTypes.MANUAL_ROLLING_MACHINE.get(), ManualRollingMachineScreen::new);
        event.register((MenuType)RailcraftMenuTypes.POWERED_ROLLING_MACHINE.get(), PoweredRollingMachineScreen::new);
        event.register((MenuType)RailcraftMenuTypes.COKE_OVEN.get(), CokeOvenScreen::new);
        event.register((MenuType)RailcraftMenuTypes.CRUSHER.get(), CrusherScreen::new);
        event.register((MenuType)RailcraftMenuTypes.STEAM_OVEN.get(), SteamOvenScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ITEM_MANIPULATOR.get(), ItemManipulatorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.FLUID_MANIPULATOR.get(), FluidManipulatorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.CART_DISPENSER.get(), CartDispenserScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TRAIN_DISPENSER.get(), TrainDispenserScreen::new);
        event.register((MenuType)RailcraftMenuTypes.CARGO_MINECART.get(), CargoMinecartScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TANK_MINECART.get(), TankMinecartScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ENERGY_MINECART.get(), EnergyMinecartScreen::new);
        event.register((MenuType)RailcraftMenuTypes.SWITCH_TRACK_ROUTER.get(), SwitchTrackRouterScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TUNNEL_BORE.get(), TunnelBoreScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ROUTING_TRACK.get(), RoutingTrackScreen::new);
        event.register((MenuType)RailcraftMenuTypes.DUMPING_TRACK.get(), DumpingTrackScreen::new);
        event.register((MenuType)RailcraftMenuTypes.SHEEP_DETECTOR.get(), SheepDetectorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.LOCOMOTIVE_DETECTOR.get(), LocomotiveDetectorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.TANK_DETECTOR.get(), TankDetectorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ADVANCED_DETECTOR.get(), AdvancedDetectorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ITEM_DETECTOR.get(), ItemDetectorScreen::new);
        event.register((MenuType)RailcraftMenuTypes.ROUTING_DETECTOR.get(), RoutingDetectorScreen::new);
    }

    private static void handleClientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("patchouli")) {
            Patchouli.setup();
        }
        if (ModList.get().isLoaded("sodiumdynamiclights")) {
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)RailcraftEntityTypes.CREATIVE_LOCOMOTIVE.get()), loco -> loco.isRunning() ? 12 : 0);
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get()), loco -> loco.isRunning() ? Math.round(loco.getLightLevel()) : 0);
        }
    }

    private static void registerItemTintSources(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(RailcraftConstants.rl("locomotive_color"), LocomotiveColor.MAP_CODEC);
    }

    private static void handleBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> ((DyeColor)state.getValue(ForceTrackEmitterBlock.COLOR)).getMapColor().col, new Block[]{(Block)RailcraftBlocks.FORCE_TRACK_EMITTER.get()});
        event.register((state, level, pos, tintIndex) -> ((DyeColor)state.getValue(ForceTrackBlock.COLOR)).getMapColor().col, new Block[]{(Block)RailcraftBlocks.FORCE_TRACK.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)RailcraftBlocks.ABANDONED_TRACK.get()});
    }

    private static void handleParticleRegistration(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.STEAM.get(), SteamParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.SPARK.get(), SparkParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.PUMPKIN.get(), PumpkinParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.TUNING_AURA.get(), TuningAuraParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.FIRE_SPARK.get(), FireSparkParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.FORCE_SPAWN.get(), ForceSpawnParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.CHIMNEY.get(), ChimneyParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.CHUNK_LOADER.get(), ChunkLoaderParticle.Provider::new);
    }

    private static void handleRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        RailcraftEntityRenderers.register(event);
        RailcraftBlockEntityRenderers.register(event);
    }

    private static void handleRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        RailcraftLayerDefinitions.createRoots((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    private static void handleKeyRegister(RegisterKeyMappingsEvent event) {
        for (KeyBinding keyBinding : KeyBinding.values()) {
            event.register(keyBinding.getKeyMapping());
        }
        event.registerCategory(RailcraftKeyMappingCategory.DEFAULT);
    }

    private static void handleClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerBlock(new IClientBlockExtensions(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine particleEngine) {
                return true;
            }

            public boolean addHitEffects(BlockState state, Level level, @Nullable HitResult result, ParticleEngine particleEngine) {
                return true;
            }
        }, new Block[]{(Block)RailcraftBlocks.RITUAL.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = RailcraftConstants.rl("block/steam_still");

            public int getTintColor() {
                return -657931;
            }

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return STILL_TEXTURE;
            }
        }, new FluidType[]{RailcraftFluidTypes.STEAM.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_still");
            private static final ResourceLocation FLOW_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_flow");

            public int getTintColor() {
                return -9805312;
            }

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOW_TEXTURE;
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                float x = (float)Integer.parseInt("6A", 16) / 255.0f;
                float y = (float)Integer.parseInt("62", 16) / 255.0f;
                float z = (float)Integer.parseInt("00", 16) / 255.0f;
                return new Vector4f(x, y, z, fluidFogColor.w());
            }

            public void modifyFogRender(Camera camera, @Nullable FogEnvironment environment, float renderDistance, float partialTick, FogData fogData) {
                fogData.renderDistanceStart = 0.0f;
                fogData.renderDistanceEnd = 3.0f;
            }
        }, new FluidType[]{RailcraftFluidTypes.CREOSOTE.get()});
    }

    private static void handleSpecialRenderers(RegisterSpecialModelRendererEvent event) {
        event.register(RailcraftConstants.rl("void_chest"), VoidChestItemRenderer.Unbaked.MAP_CODEC);
    }

    private static void handleSpecialBlockRenderers(RegisterSpecialBlockModelRendererEvent event) {
        event.register((Block)RailcraftBlocks.VOID_CHEST.get(), (SpecialModelRenderer.Unbaked)new VoidChestItemRenderer.Unbaked(VoidChestRenderer.VOID_CHEST.texture()));
    }

    @SubscribeEvent
    static void handleClientTick(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().level != null && !Minecraft.getInstance().isPaused()) {
            SignalAspect.tickBlinkState();
        }
    }

    @SubscribeEvent
    static void handleRenderWorldLast(RenderLevelStageEvent.AfterEntities event) {
        shuntingAuraRenderer.render(event.getPoseStack(), event.getLevelRenderState().cameraRenderState, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false));
    }

    @SubscribeEvent
    static void handleClientLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        shuntingAuraRenderer.clearCarts();
        JeiRecipeSync.clearAll();
    }

    @SubscribeEvent
    static void handleClientLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        boolean minecartImprovedFeatureFlag;
        String qualifier;
        IModInfo modInfo = (IModInfo)ModList.get().getModFileById("railcraft").getMods().getFirst();
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)modInfo);
        VersionChecker.Status versionStatus = result.status();
        if (versionStatus.shouldDraw()) {
            String newVersion = result.target().toString();
            String modUrl = ((URL)modInfo.getModURL().orElseThrow()).toString();
            MutableComponent message = Component.literal((String)"Railcraft Reborn: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"A new version (%s) is available to download.".formatted(newVersion)).withStyle(style -> style.withColor(ChatFormatting.WHITE).withUnderlined(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(modUrl)))));
            event.getPlayer().displayClientMessage((Component)message, false);
        }
        boolean isSnapshot = (qualifier = modInfo.getVersion().getQualifier()) != null && qualifier.equals("snapshot");
        boolean showMessageBeta = (Boolean)RailcraftConfig.CLIENT.showBetaMessage.get();
        if (SharedConstants.IS_RUNNING_IN_IDE || isSnapshot || showMessageBeta) {
            String type = isSnapshot ? "development" : "beta";
            String issueUrl = ((ModFileInfo)modInfo.getOwningFile()).getIssueURL().toString();
            Component message = CommonComponents.joinLines((Component[])new Component[]{Component.literal((String)"You are using a %s version of %s.".formatted(type, "Railcraft Reborn")).withStyle(ChatFormatting.RED), Component.literal((String)"- Features might be missing or only partially implemented.").withStyle(ChatFormatting.GRAY), Component.literal((String)"Bug reports are welcome at our issue tracker.").withStyle(style -> style.withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(issueUrl)))), Component.literal((String)"- Sm0keySa1m0n, Edivad99").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})});
            event.getPlayer().displayClientMessage(message, false);
        }
        if (minecartImprovedFeatureFlag = event.getPlayer().level().enabledFeatures().contains(FeatureFlags.MINECART_IMPROVEMENTS)) {
            Component message = CommonComponents.joinLines((Component[])new Component[]{Component.literal((String)"The 'Minecart Improvements' experiment is enabled.").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}), Component.literal((String)"Some Railcraft features may not work as intended.").withStyle(ChatFormatting.YELLOW)});
            event.getPlayer().displayClientMessage(message, false);
        }
    }

    @SubscribeEvent
    static void handleItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        Boolean clickToCraft = (Boolean)itemStack.getOrDefault(RailcraftDataComponents.CLICK_TO_CRAFT, (Object)false);
        if (clickToCraft.booleanValue()) {
            event.getToolTip().add(Component.translatable((String)Translations.Tips.CLICK_TO_CRAFT).withStyle(ChatFormatting.YELLOW));
        }
    }

    @SubscribeEvent
    static void handleRecipesReceived(RecipesReceivedEvent event) {
        JeiRecipeSync.setBlastFurnaceRecipes(event.getRecipeMap().byType((RecipeType)RailcraftRecipeTypes.BLASTING.get()));
        JeiRecipeSync.setRollingRecipes(event.getRecipeMap().byType((RecipeType)RailcraftRecipeTypes.ROLLING.get()));
        JeiRecipeSync.setCokingRecipes(event.getRecipeMap().byType((RecipeType)RailcraftRecipeTypes.COKING.get()));
        JeiRecipeSync.setCrushingRecipes(event.getRecipeMap().byType((RecipeType)RailcraftRecipeTypes.CRUSHING.get()));
    }

    @SubscribeEvent
    static void handleKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (Minecraft.getInstance().screen instanceof ChatScreen) {
            return;
        }
        if (KeyBinding.CHANGE_AURA.consumeClick()) {
            GogglesItem.changeAuraByKey(player);
        }
        if (!(player.getVehicle() instanceof Minecart)) {
            return;
        }
        if (KeyBinding.REVERSE.consumeClick()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLocomotiveByKeyMessage(SetLocomotiveByKeyMessage.LocomotiveKeyBinding.REVERSE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KeyBinding.FASTER.consumeClick()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLocomotiveByKeyMessage(SetLocomotiveByKeyMessage.LocomotiveKeyBinding.FASTER), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KeyBinding.SLOWER.consumeClick()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLocomotiveByKeyMessage(SetLocomotiveByKeyMessage.LocomotiveKeyBinding.SLOWER), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KeyBinding.MODE_CHANGE.consumeClick()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLocomotiveByKeyMessage(SetLocomotiveByKeyMessage.LocomotiveKeyBinding.MODE_CHANGE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (KeyBinding.WHISTLE.consumeClick()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLocomotiveByKeyMessage(SetLocomotiveByKeyMessage.LocomotiveKeyBinding.WHISTLE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

