/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.color.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.world.item.component.LocomotiveColorComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record LocomotiveColor(int index) implements ItemTintSource
{
    public static final MapCodec<LocomotiveColor> MAP_CODEC = RecordCodecBuilder.mapCodec(loco -> loco.group((App)Codec.INT.fieldOf("index").forGetter(LocomotiveColor::index)).apply((Applicative)loco, LocomotiveColor::new));

    public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
        LocomotiveColorComponent color = (LocomotiveColorComponent)itemStack.get(RailcraftDataComponents.LOCOMOTIVE_COLOR);
        DyeColor selectedColor = this.index == 0 ? color.primary() : color.secondary();
        return ARGB.opaque((int)selectedColor.getMapColor().col);
    }

    public MapCodec<? extends ItemTintSource> type() {
        return MAP_CODEC;
    }
}

