/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.to_server.SetEmbarkingTrackMessage;
import mods.railcraft.world.level.block.track.outfitted.EmbarkingTrackBlock;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class EmbarkingTrackScreen
extends IngameWindowScreen {
    private final BlockPos blockPos;
    private int radius;
    private Button incrementButton;
    private Button decrementButton;

    public EmbarkingTrackScreen(BlockState blockState, BlockPos blockPos) {
        super((Component)blockState.getBlock().getName());
        this.blockPos = blockPos;
        this.radius = EmbarkingTrackBlock.getRadius(blockState);
    }

    protected void init() {
        super.init();
        int centreX = (this.width - this.windowWidth) / 2;
        int centreY = (this.height - this.windowHeight) / 2;
        this.decrementButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-1"), __ -> this.setRadius(this.radius - 1)).bounds(centreX + 53, centreY + 50, 30, 20).build());
        this.incrementButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+1"), __ -> this.setRadius(this.radius + 1)).bounds(centreX + 93, centreY + 50, 30, 20).build());
        this.updateButtons();
    }

    private void setRadius(int radius) {
        this.radius = radius;
        this.updateButtons();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetEmbarkingTrackMessage(this.blockPos, this.radius), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateButtons() {
        this.incrementButton.active = this.radius < 5;
        this.decrementButton.active = this.radius > 1;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent componentRadius = Component.translatable((String)Translations.Screen.EMBARKING_TRACK_RADIUS, (Object[])new Object[]{this.radius});
        GuiUtil.drawCenteredString(guiGraphics, this.font, (Component)componentRadius, this.windowWidth, 25);
    }
}

