/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.network.to_server.EditTicketMessage;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.joml.Matrix3x2fStack;

public class GoldenTicketScreen
extends IngameWindowScreen {
    private static final ResourceLocation TICKET_LOCATION = RailcraftConstants.rl("textures/gui/item/golden_ticket.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 136;
    private static final String PREFIX = "Dest=";
    private final ItemStack itemStack;
    private final InteractionHand hand;
    private String dest;
    private RailcraftButton helpButton;
    private EditBox editBoxDest;
    private boolean readingManual;

    public GoldenTicketScreen(ItemStack itemStack, InteractionHand hand) {
        super(GameNarrator.NO_TITLE, TICKET_LOCATION, 256, 136);
        this.itemStack = itemStack;
        this.hand = hand;
        this.dest = PREFIX + TicketItem.getDestination(this.itemStack);
        this.readingManual = false;
    }

    protected void init() {
        RailcraftButton doneButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_DONE, button -> {
            this.sendMessageToServer();
            this.minecraft.setScreen(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        this.helpButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> {
            this.readingManual = !this.readingManual;
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        RailcraftButton cancelButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(null), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        LinearLayout layout = new LinearLayout(this.width / 2 - 100, this.height / 2 + 75, LinearLayout.Orientation.HORIZONTAL);
        layout.spacing(4);
        layout.addChild((LayoutElement)doneButton);
        layout.addChild((LayoutElement)this.helpButton);
        layout.addChild((LayoutElement)cancelButton);
        layout.arrangeElements();
        this.editBoxDest = new EditBox(this.font, this.width / 2 - 117, this.height / 2 + 23, 234, 20, (Component)Component.empty());
        this.editBoxDest.setValue(this.dest);
        this.editBoxDest.setBordered(false);
        this.addRenderableWidget((GuiEventListener)this.editBoxDest);
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.readingManual) {
            this.editBoxDest.setVisible(false);
            MutableComponent about = Component.translatable((String)Translations.Screen.GOLDEN_TICKET_ABOUT);
            MutableComponent help = Component.translatable((String)Translations.Screen.GOLDEN_TICKET_HELP).withStyle(ChatFormatting.BLACK);
            guiGraphics.drawString(this.font, (Component)about, this.windowWidth / 2 - this.font.width((FormattedText)about) / 2, 15, -12566464, false);
            guiGraphics.drawWordWrap(this.font, (FormattedText)help, 15, 30, 230, -12566464, false);
            this.helpButton.setMessage(CommonComponents.GUI_BACK);
        } else {
            MutableComponent title = Component.translatable((String)Translations.Screen.GOLDEN_TICKET_TITLE).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
            MutableComponent desc1 = Component.translatable((String)Translations.Screen.GOLDEN_TICKET_DESC_1);
            MutableComponent desc2 = Component.translatable((String)Translations.Screen.GOLDEN_TICKET_DESC_2);
            Matrix3x2fStack poseStack = guiGraphics.pose();
            poseStack.pushMatrix();
            poseStack.scale(2.0f, 2.0f);
            guiGraphics.drawCenteredString(this.font, (Component)title, 64, 8, -12566464);
            poseStack.popMatrix();
            guiGraphics.drawString(this.font, (Component)desc1, this.windowWidth / 2 - this.font.width((FormattedText)desc1) / 2, 45, -12566464, false);
            guiGraphics.drawString(this.font, (Component)desc2, this.windowWidth / 2 - this.font.width((FormattedText)desc2) / 2, 60, -12566464, false);
            this.editBoxDest.setVisible(true);
            this.helpButton.setMessage((Component)Component.translatable((String)Translations.Screen.HELP));
        }
    }

    private void sendMessageToServer() {
        this.dest = this.editBoxDest.getValue();
        boolean isValid = this.dest.startsWith(PREFIX);
        if (!isValid) {
            return;
        }
        this.dest = this.dest.trim();
        String destWithoutPrefix = this.dest.substring(PREFIX.length());
        boolean success = TicketItem.setTicketData(this.itemStack, destWithoutPrefix, this.minecraft.player.nameAndId());
        if (success) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new EditTicketMessage(this.hand, destWithoutPrefix), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

