/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.RoutingTableBookHelpScreen;
import mods.railcraft.client.gui.screen.RoutingTableBookTitleScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.RailcraftPageButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.network.to_server.EditRoutingTableBookMessage;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.RoutingTableBookContent;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class RoutingTableBookScreen
extends Screen {
    static final ResourceLocation BOOK_LOCATION = RailcraftConstants.rl("textures/gui/item/routing_table_book.png");
    static final int TEXT_WIDTH = 220;
    static final int TEXT_HEIGHT = 128;
    static final int IMAGE_WIDTH = 256;
    static final int IMAGE_HEIGHT = 192;
    static final int BACKGROUND_TEXTURE_WIDTH = 256;
    static final int BACKGROUND_TEXTURE_HEIGHT = 256;
    private final Player owner;
    private final ItemStack book;
    private final RoutingTableBookHelpScreen helpScreen;
    private final RoutingTableBookTitleScreen titleScreen;
    private int currentPage;
    private final List<String> pages = Lists.newArrayList();
    private RailcraftPageButton forwardButton;
    private RailcraftPageButton backButton;
    private final InteractionHand hand;
    private Component numberOfPages = CommonComponents.EMPTY;
    private MultiLineEditBox page;
    private static final int BOOK_MAX_PAGES = 50;
    private RailcraftButton titleButton;
    private RailcraftButton helpButton;

    public RoutingTableBookScreen(Player owner, ItemStack book, InteractionHand hand) {
        super(GameNarrator.NO_TITLE);
        this.owner = owner;
        this.book = book;
        this.hand = hand;
        RoutingTableBookContent writableBookContent = (RoutingTableBookContent)book.get(RailcraftDataComponents.ROUTING_TABLE_BOOK);
        if (writableBookContent != null) {
            this.pages.addAll(writableBookContent.pages());
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
        this.helpScreen = new RoutingTableBookHelpScreen(this);
        this.titleScreen = new RoutingTableBookTitleScreen(this, owner, hand, this.pages);
    }

    private int getNumPages() {
        return this.pages.size();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        this.page = MultiLineEditBox.builder().setShowDecorations(false).setTextColor(-16777216).setCursorColor(-16777216).setShowBackground(false).setTextShadow(false).setX((this.width - 220) / 2 - 7).setY((this.height - 128) / 2 - 10).build(this.font, 220, 134, CommonComponents.EMPTY);
        this.page.setCharacterLimit(1024);
        this.page.setLineLimit(14);
        this.page.setValueListener(s -> this.pages.set(this.currentPage, (String)s));
        this.addRenderableWidget((GuiEventListener)this.page);
        this.updatePageContent();
        this.numberOfPages = this.getPageNumberMessage();
        this.backButton = (RailcraftPageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 30, yOffset + 150, false, BOOK_LOCATION, button -> this.pageBack()));
        this.forwardButton = (RailcraftPageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 200, yOffset + 150, true, BOOK_LOCATION, button -> this.pageForward()));
        this.titleButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.NAME, button -> this.minecraft.setScreen((Screen)this.titleScreen), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        this.helpButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> this.minecraft.setScreen((Screen)this.helpScreen), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        RailcraftButton doneButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_DONE, button -> {
            this.saveChanges();
            this.minecraft.setScreen(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        LinearLayout layout = new LinearLayout(this.width / 2 - 100, this.height / 2 + 90, LinearLayout.Orientation.HORIZONTAL);
        layout.spacing(4);
        layout.addChild((LayoutElement)this.titleButton);
        layout.addChild((LayoutElement)this.helpButton);
        layout.addChild((LayoutElement)doneButton);
        layout.arrangeElements();
        this.updateButtonVisibility();
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.page);
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.getPageNumberMessage()});
    }

    private Component getPageNumberMessage() {
        return Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getNumPages()});
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updatePageContent();
        }
        this.updateButtonVisibility();
    }

    private void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        } else {
            this.appendPageToBook();
            if (this.currentPage < this.getNumPages() - 1) {
                ++this.currentPage;
            }
        }
        this.updatePageContent();
        this.updateButtonVisibility();
    }

    private void updatePageContent() {
        this.page.setValue(this.pages.get(this.currentPage), true);
        this.numberOfPages = this.getPageNumberMessage();
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < 49;
        this.backButton.visible = this.currentPage > 0;
    }

    private void eraseEmptyTrailingPages() {
        ListIterator<String> listiterator = this.pages.listIterator(this.pages.size());
        while (listiterator.hasPrevious() && listiterator.previous().isEmpty()) {
            listiterator.remove();
        }
    }

    private void saveChanges() {
        this.eraseEmptyTrailingPages();
        this.updateLocalCopy();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new EditRoutingTableBookMessage(this.hand, this.pages, Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateLocalCopy() {
        this.book.set(RailcraftDataComponents.ROUTING_TABLE_BOOK, (Object)new RoutingTableBookContent(this.pages, this.owner.getGameProfile().name(), Optional.empty()));
    }

    private void appendPageToBook() {
        if (this.getNumPages() < 50) {
            this.pages.add("");
        }
    }

    public boolean keyPressed(KeyEvent event) {
        switch (event.key()) {
            case 266: {
                this.backButton.onPress((InputWithModifiers)event);
                return true;
            }
            case 267: {
                this.forwardButton.onPress((InputWithModifiers)event);
                return true;
            }
        }
        return super.keyPressed(event);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        int l = this.font.width((FormattedText)this.numberOfPages);
        guiGraphics.drawString(this.font, this.numberOfPages, xOffset - l + 225, yOffset + 15, -16777216, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BOOK_LOCATION, xOffset, yOffset, 0.0f, 0.0f, 256, 192, 256, 256);
    }
}

