/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.to_server.SetTrainDetectorMessage;
import mods.railcraft.world.level.block.entity.detector.TrainDetectorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class TrainDetectorScreen
extends IngameWindowScreen {
    private final TrainDetectorBlockEntity trainDetector;

    public TrainDetectorScreen(TrainDetectorBlockEntity trainDetector) {
        super(trainDetector.getDisplayName(), LARGE_WINDOW_TEXTURE, 176, 113);
        this.trainDetector = trainDetector;
    }

    public void init() {
        int centeredX = (this.width - this.windowWidth) / 2;
        int centeredY = (this.height - this.windowHeight) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-10"), __ -> this.incrementLength(-10)).bounds(centeredX + 13, centeredY + 50, 30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"-1"), __ -> this.incrementLength(-1)).bounds(centeredX + 53, centeredY + 50, 30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+1"), __ -> this.incrementLength(1)).bounds(centeredX + 93, centeredY + 50, 30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+10"), __ -> this.incrementLength(10)).bounds(centeredX + 133, centeredY + 50, 30, 20).build());
    }

    private void incrementLength(int incrementAmount) {
        int size = Mth.clamp((int)(this.trainDetector.getTrainSize() + incrementAmount), (int)1, (int)100);
        if (this.trainDetector.getTrainSize() != size) {
            this.trainDetector.setTrainSize(size);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetTrainDetectorMessage(this.trainDetector.getBlockPos(), this.trainDetector.getTrainSize()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent componentForce = Component.translatable((String)Translations.Screen.TRAIN_DETECTOR_SIZE, (Object[])new Object[]{this.trainDetector.getTrainSize()});
        GuiUtil.drawCenteredString(guiGraphics, this.font, (Component)componentForce, this.windowWidth, 25);
    }
}

