/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.world.inventory.BlastFurnaceMenu;
import mods.railcraft.world.module.BlastFurnaceModule;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BlastFurnaceScreen
extends RailcraftMenuScreen<BlastFurnaceMenu> {
    private static final ResourceLocation WIDGETS_TEXTURE = RailcraftConstants.rl("textures/gui/container/blast_furnace.png");

    public BlastFurnaceScreen(BlastFurnaceMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        BlastFurnaceModule logic = ((BlastFurnaceMenu)this.menu).getBlastFurnace().getBlastFurnaceModule();
        if (logic.isBurning()) {
            int burnProgressScale = logic.getBurnProgressScaled(12);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_TEXTURE, x + 56, y + 36 + 12 - burnProgressScale, 176.0f, (float)(12 - burnProgressScale), 14, burnProgressScale + 2, 256, 256);
        }
        int progressScale = (int)(logic.getProgressPercent() * 24.0f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_TEXTURE, x + 79, y + 34, 176.0f, 14.0f, progressScale + 1, 16, 256, 256);
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return WIDGETS_TEXTURE;
    }
}

