/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.screen.inventory.widget.FluidGaugeRenderer;
import mods.railcraft.world.inventory.CokeOvenMenu;
import mods.railcraft.world.module.CokeOvenModule;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CokeOvenScreen
extends RailcraftMenuScreen<CokeOvenMenu> {
    private static final ResourceLocation WIDGETS_TEXTURE = RailcraftConstants.rl("textures/gui/container/coke_oven.png");

    public CokeOvenScreen(CokeOvenMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.registerWidgetRenderer(new FluidGaugeRenderer(((CokeOvenMenu)this.menu).getFluidGauge()));
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        CokeOvenModule logic = ((CokeOvenMenu)this.menu).getCokeOven().getCokeOvenModule();
        if (logic.getProgress() > 0) {
            float progressPercent = logic.getProgressPercent();
            int burnProgress = (int)((1.0 - (double)progressPercent) * 12.0);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_TEXTURE, x + 16, y + 38 - burnProgress, 176.0f, (float)(59 - burnProgress), 14, burnProgress + 2, 256, 256);
            int cookProgress = (int)(progressPercent * 20.0f);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_TEXTURE, x + 34, y + 43, 176.0f, 61.0f, cookProgress + 1, 16, 256, 256);
        }
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return WIDGETS_TEXTURE;
    }
}

