/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.client.gui.widget.button.ToggleButton;
import mods.railcraft.network.to_server.SetLocomotiveMessage;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.LocomotiveMenu;
import mods.railcraft.world.inventory.slot.ItemFilterSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.apache.commons.lang3.StringUtils;

public abstract class LocomotiveScreen<T extends LocomotiveMenu<?>>
extends RailcraftMenuScreen<T> {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final Locomotive locomotive;
    private final String type;
    private final Map<Locomotive.Mode, Button> modeButtons = new EnumMap<Locomotive.Mode, Button>(Locomotive.Mode.class);
    private final Map<Locomotive.Speed, Button> speedButtons = new EnumMap<Locomotive.Speed, Button>(Locomotive.Speed.class);
    private ToggleButton reverseButton;
    private MultiButton<Locomotive.Lock> lockButton;
    private int refreshTimer;

    protected LocomotiveScreen(T menu, Inventory inventory, Component title, String type) {
        super(menu, inventory, title);
        this.locomotive = ((LocomotiveMenu)((Object)menu)).getLocomotive();
        this.type = type;
        this.imageHeight = 161;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    private Optional<Tooltip> createLockTooltip(Locomotive.Lock lock) {
        return Optional.of(Tooltip.create((Component)(switch (lock) {
            default -> throw new MatchException(null, null);
            case Locomotive.Lock.LOCKED -> Component.translatable((String)Translations.Screen.LOCOMOTIVE_LOCK_LOCKED, (Object[])new Object[]{this.locomotive.getOwnerOrThrow().name()});
            case Locomotive.Lock.UNLOCKED -> Component.translatable((String)Translations.Screen.LOCOMOTIVE_LOCK_UNLOCKED);
            case Locomotive.Lock.PRIVATE -> Component.translatable((String)Translations.Screen.LOCOMOTIVE_LOCK_PRIVATE, (Object[])new Object[]{this.locomotive.getOwnerOrThrow().name()});
        })));
    }

    public void init() {
        super.init();
        int centreX = (this.width - this.getXSize()) / 2;
        int centreY = (this.height - this.getYSize()) / 2;
        LinearLayout layout = LinearLayout.vertical();
        layout.setPosition(centreX + 4, centreY + this.getYSize() - 129);
        LinearLayout modeLayout = (LinearLayout)layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(2));
        for (Locomotive.Mode mode : this.locomotive.getSupportedModes()) {
            MutableComponent tooltip = Component.translatable((String)Translations.makeKey("screen", String.format("locomotive.%s.mode.description.%s", this.type, mode.getSerializedName())));
            RailcraftButton button = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(mode.getDisplayName(), __ -> this.setMode(mode), (TexturePosition)ButtonTexture.SMALL_BUTTON).size(54, 16)).tooltip(Tooltip.create((Component)tooltip))).build());
            modeLayout.addChild((LayoutElement)button);
            this.modeButtons.put(mode, button);
        }
        LinearLayout speedLayout = (LinearLayout)layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(4));
        this.reverseButton = (ToggleButton)this.addRenderableWidget((GuiEventListener)((ToggleButton)((ToggleButton.Builder)ToggleButton.toggleBuilder((Component)Component.literal((String)"R"), __ -> this.toggleReverse(), ButtonTexture.SMALL_BUTTON).size(12, 16)).toggled(this.locomotive.isReverse()).build()));
        speedLayout.addChild((LayoutElement)this.reverseButton);
        for (Locomotive.Speed speed : Locomotive.Speed.values()) {
            RailcraftButton button = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder((Component)Component.literal((String)StringUtils.repeat((char)'>', (int)speed.getLevel())), __ -> this.setSpeed(speed), (TexturePosition)ButtonTexture.SMALL_BUTTON).size(4 + speed.getLevel() * 6, 16)).build());
            button.active = this.locomotive.getSpeed() == speed;
            speedLayout.addChild((LayoutElement)button);
            this.speedButtons.put(speed, button);
        }
        this.lockButton = (MultiButton)this.addRenderableWidget((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.locomotive.getLock()).bounds(centreX + 154, centreY + this.getYSize() - 111, 16, 16)).tooltipFactory(this::createLockTooltip).stateCallback(this::setLock).build()));
        this.updateButtons();
        layout.arrangeElements();
    }

    private void setMode(Locomotive.Mode mode) {
        if (this.locomotive.getMode() != mode) {
            this.locomotive.setMode(mode);
            this.sendAttributes();
        }
    }

    private void setSpeed(Locomotive.Speed speed) {
        if (this.locomotive.getSpeed() != speed) {
            this.locomotive.setSpeed(speed);
            this.sendAttributes();
        }
    }

    private void setLock(Locomotive.Lock lock) {
        if (this.locomotive.getLock() != lock) {
            this.locomotive.setLock(lock);
            this.locomotive.setOwner(lock == Locomotive.Lock.UNLOCKED ? null : this.minecraft.player.nameAndId());
            this.sendAttributes();
        }
    }

    private void toggleReverse() {
        this.locomotive.setReverse(!this.locomotive.isReverse());
        this.sendAttributes();
    }

    protected void sendAttributes() {
        this.updateButtons();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLocomotiveMessage(this.locomotive.getId(), this.locomotive.getMode(), this.locomotive.getSpeed(), this.locomotive.getLock(), this.locomotive.isReverse()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void containerTick() {
        super.containerTick();
        if (this.refreshTimer++ >= 20) {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.modeButtons.forEach((mode, button) -> {
            button.active = this.locomotive.getMode() != mode && this.locomotive.isAllowedMode((Locomotive.Mode)((Object)mode));
        });
        this.speedButtons.forEach((speed, button) -> {
            button.active = this.locomotive.getSpeed() != speed && (!this.locomotive.isReverse() || speed.getLevel() <= this.locomotive.getMaxReverseSpeed().getLevel());
        });
        this.reverseButton.setToggled(this.locomotive.isReverse());
        this.lockButton.active = !this.locomotive.isLocked() || this.locomotive.getOwnerOrThrow().equals((Object)this.minecraft.player.getGameProfile());
        this.lockButton.setState(this.locomotive.getLock());
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        ItemFilterSlot slotTicket;
        super.renderTooltip(guiGraphics, x, y);
        Slot slot = this.hoveredSlot;
        if (slot instanceof ItemFilterSlot && !(slotTicket = (ItemFilterSlot)slot).hasItem()) {
            slotTicket.setTooltip(Collections.singletonList(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)Translations.Tips.LOCOMOTIVE_SLOT_TICKET).getVisualOrderText())));
        }
    }
}

