/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.widget;

import java.util.List;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.gui.widget.FluidGaugeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidGaugeRenderer
extends WidgetRenderer<FluidGaugeWidget> {
    public FluidGaugeRenderer(FluidGaugeWidget widget) {
        super(widget);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        return ((FluidGaugeWidget)this.widget).getTooltip().stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
    }

    @Override
    public void render(ResourceLocation widgetLocation, GuiGraphics guiGraphics, int centreX, int centreY, int mouseX, int mouseY) {
        FluidStack fluidStack = ((FluidGaugeWidget)this.widget).tank.getFluidStack();
        if (fluidStack.isEmpty()) {
            return;
        }
        TextureAtlasSprite fluidIcon = FluidRenderer.getFluidTexture(fluidStack, FluidRenderer.FluidType.STILL);
        float scale = (float)Math.min(fluidStack.getAmount(), ((FluidGaugeWidget)this.widget).tank.getCapacity()) / (float)((FluidGaugeWidget)this.widget).tank.getCapacity();
        int color = RenderUtil.getColorARGB(fluidStack);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, fluidIcon, centreX + ((FluidGaugeWidget)this.widget).x, centreY + ((FluidGaugeWidget)this.widget).y, ((FluidGaugeWidget)this.widget).w, ((FluidGaugeWidget)this.widget).h, color);
        int mask = Mth.floor((float)((float)((FluidGaugeWidget)this.widget).h * scale));
        if (mask == 0) {
            mask = 1;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, widgetLocation, centreX + ((FluidGaugeWidget)this.widget).x, centreY + ((FluidGaugeWidget)this.widget).y - 1, (float)((FluidGaugeWidget)this.widget).x, (float)(((FluidGaugeWidget)this.widget).y - 1), ((FluidGaugeWidget)this.widget).w, ((FluidGaugeWidget)this.widget).h - mask + 1, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, widgetLocation, centreX + ((FluidGaugeWidget)this.widget).x, centreY + ((FluidGaugeWidget)this.widget).y, (float)((FluidGaugeWidget)this.widget).u, (float)((FluidGaugeWidget)this.widget).v, ((FluidGaugeWidget)this.widget).w, ((FluidGaugeWidget)this.widget).h, 256, 256);
    }
}

