/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.widget.button;

import java.util.function.Function;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RailcraftButton
extends Button {
    private static final ResourceLocation WIDGETS_LOCATION = RailcraftConstants.rl("textures/gui/widgets.png");
    private TexturePosition texturePosition;

    protected RailcraftButton(AbstractBuilder<?, ?> builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.createNarration);
        this.texturePosition = builder.texturePosition;
    }

    public void setTexturePosition(TexturePosition texturePosition) {
        this.texturePosition = texturePosition;
    }

    protected int getYImage(boolean hovered) {
        if (!this.active) {
            return 0;
        }
        return hovered ? 2 : 1;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        int i = this.getYImage(this.isHoveredOrFocused());
        int xOffset = this.texturePosition.x();
        int yOffset = this.texturePosition.y();
        int h = this.texturePosition.height();
        int w = this.texturePosition.width();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_LOCATION, this.getX(), this.getY(), (float)xOffset, (float)(yOffset + i * h), this.width / 2, h, 256, 256, ARGB.white((float)this.alpha));
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_LOCATION, this.getX() + this.width / 2, this.getY(), (float)(xOffset + w - this.width / 2), (float)(yOffset + i * h), this.width / 2, h, 256, 256, ARGB.white((float)this.alpha));
        int j = this.getFGColor();
        guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public static Builder builder(Component message, Button.OnPress onPress, TexturePosition texturePosition) {
        return new Builder(message, onPress, texturePosition);
    }

    public static Builder builder(String translationKey, Button.OnPress onPress, TexturePosition texturePosition) {
        return new Builder((Component)Component.translatable((String)translationKey), onPress, texturePosition);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    protected static abstract class AbstractBuilder<SELF extends AbstractBuilder<SELF, T>, T extends RailcraftButton> {
        private final Function<SELF, T> factory;
        private final Component message;
        private final Button.OnPress onPress;
        private final TexturePosition texturePosition;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = RailcraftButton.access$000();

        public AbstractBuilder(Function<SELF, T> factory, Component message, Button.OnPress onPress, TexturePosition texturePosition) {
            this.factory = factory;
            this.message = message;
            this.onPress = onPress;
            this.texturePosition = texturePosition;
        }

        public SELF pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this.self();
        }

        public SELF width(int width) {
            this.width = width;
            return this.self();
        }

        public SELF size(int width, int height) {
            this.width = width;
            this.height = height;
            return this.self();
        }

        public SELF bounds(int x, int y, int width, int height) {
            return ((AbstractBuilder)this.pos(x, y)).size(width, height);
        }

        public SELF tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this.self();
        }

        public SELF createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this.self();
        }

        public T build() {
            RailcraftButton button = (RailcraftButton)((Object)this.factory.apply(this.self()));
            button.setTooltip(this.tooltip);
            return (T)((Object)button);
        }

        protected SELF self() {
            return (SELF)this;
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, RailcraftButton> {
        public Builder(Component message, Button.OnPress onPress, TexturePosition texturePosition) {
            super(RailcraftButton::new, message, onPress, texturePosition);
        }
    }
}

