/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.widget.button;

import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;

public class ToggleButton
extends RailcraftButton {
    private boolean toggled;

    private ToggleButton(Builder builder) {
        super(builder);
        this.toggled = builder.toggled;
    }

    public void toggle() {
        this.setToggled(!this.toggled);
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }

    public void onPress(InputWithModifiers modifiers) {
        this.toggle();
        super.onPress(modifiers);
    }

    @Override
    protected int getYImage(boolean hovered) {
        if (this.toggled) {
            return 3;
        }
        return super.getYImage(hovered);
    }

    public static Builder toggleBuilder(Component message, Button.OnPress onPress, TexturePosition texturePosition) {
        return new Builder(message, onPress, texturePosition);
    }

    public static class Builder
    extends RailcraftButton.AbstractBuilder<Builder, ToggleButton> {
        private boolean toggled;

        public Builder(Component message, Button.OnPress onPress, TexturePosition texturePosition) {
            super(ToggleButton::new, message, onPress, texturePosition);
        }

        public Builder toggled(boolean toggled) {
            this.toggled = toggled;
            return this;
        }
    }
}

