/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.particle.ChunkLoaderParticleOptions;
import mods.railcraft.world.item.GogglesItem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class ChunkLoaderParticle
extends SingleQuadParticle {
    private final Vec3 dest;

    private ChunkLoaderParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, ChunkLoaderParticleOptions options, TextureAtlasSprite sprite) {
        super(level, x, y, z, dx, dy, dz, sprite);
        this.dest = options.destination();
        this.calculateVector();
        this.scale(1.2f);
        float brightness = this.random.nextFloat() * 0.6f + 0.4f;
        this.gCol = this.bCol = 1.0f * brightness;
        this.rCol = this.bCol;
        this.gCol *= 0.3f;
        this.rCol *= 0.9f;
        this.setLifetime(250);
        this.hasPhysics = false;
    }

    private void calculateVector() {
        Vec3 vecParticle = new Vec3(this.x, this.y, this.z);
        Vec3 vel = this.dest.subtract(vecParticle);
        vel = vel.normalize();
        float velScale = 0.08f;
        this.xd = vel.x * (double)velScale;
        this.yd = vel.y * (double)velScale;
        this.zd = vel.z * (double)velScale;
    }

    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        if (Minecraft.getInstance().player.distanceToSqr(this.dest) > 25600.0) {
            return;
        }
        if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.WORLDSPIKE)) {
            super.extract(state, camera, partialTicks);
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!GogglesItem.isGoggleAuraActive(GogglesItem.Aura.WORLDSPIKE)) {
            this.remove();
            return;
        }
        if (!this.level.isLoaded(BlockPos.containing((Position)this.dest))) {
            this.remove();
            return;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        if (this.getPos().distanceToSqr(this.dest) <= 0.5) {
            this.remove();
            return;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<ChunkLoaderParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ChunkLoaderParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz, RandomSource randomSource) {
            return new ChunkLoaderParticle(level, x, y, z, dx, dy, dz, options, this.sprites.get(randomSource));
        }
    }
}

