/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.client.particle.DimmableParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class SparkParticle
extends DimmableParticle {
    private SparkParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, TextureAtlasSprite sprite) {
        super(level, x, y, z, dx, dy, dz, sprite);
        this.gravity = 1.0f;
        this.setLifetime(this.random.nextInt(10) + 10);
        this.setSize(0.15f, 0.15f);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz, RandomSource randomSource) {
            return new SparkParticle(level, x, y, z, dx, dy + 1.0, dz, this.sprites.get(randomSource));
        }
    }
}

