/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.client.renderer.blockentity.state.AbstractSignalBoxRenderState;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSignalBoxRenderer
implements BlockEntityRenderer<AbstractSignalBoxBlockEntity, AbstractSignalBoxRenderState> {
    private static final Map<SignalAspect, ResourceLocation> ASPECT_TEXTURE_LOCATIONS = Map.of(SignalAspect.OFF, RailcraftConstants.rl("entity/signal_box_aspect/off"), SignalAspect.RED, RailcraftConstants.rl("entity/signal_box_aspect/red"), SignalAspect.YELLOW, RailcraftConstants.rl("entity/signal_box_aspect/yellow"), SignalAspect.GREEN, RailcraftConstants.rl("entity/signal_box_aspect/green"));
    private static final ResourceLocation SIDE_TEXTURE_LOCATION = RailcraftConstants.rl("entity/signal_box/side");
    private static final ResourceLocation CONNECTED_SIDE_TEXTURE_LOCATION = RailcraftConstants.rl("entity/signal_box/connected_side");
    private static final ResourceLocation BOTTOM_TEXTURE_LOCATION = RailcraftConstants.rl("entity/signal_box/bottom");
    private final CuboidModel model = new CuboidModel(0.125f, 0.0f, 0.125f, 0.875f, 0.9375f, 0.875f);

    protected abstract ResourceLocation getTopTextureLocation();

    public int getViewDistance() {
        return 512;
    }

    public AbstractSignalBoxRenderState createRenderState() {
        return new AbstractSignalBoxRenderState();
    }

    public void extractRenderState(AbstractSignalBoxBlockEntity blockEntity, AbstractSignalBoxRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        renderState.customName = Optional.ofNullable(blockEntity.getCustomName());
        renderState.level = blockEntity.getLevel();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean isConnected = SignalBoxBlock.isConnected(blockEntity.getBlockState(), direction);
            renderState.directionConnections.put(direction, isConnected);
            SignalAspect aspect = blockEntity.getSignalAspect(direction).getDisplayAspect();
            renderState.directionSignalAspects.put(direction, aspect);
        }
    }

    public void submit(AbstractSignalBoxRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        collector.submitCustomGeometry(poseStack, RenderType.lines(), (pose, vertexConsumer) -> {
            if (state.level != null) {
                BlockEntity blockEntity = state.level.getBlockEntity(state.blockPos);
                if (blockEntity == null) {
                    return;
                }
                SignalAuraRenderUtil.tryRenderSignalAura(blockEntity, pose, vertexConsumer);
            }
        });
        state.customName.ifPresent(name -> RenderUtil.renderBlockHoverText(collector, state.blockPos, name, poseStack, state.lightCoords));
        TextureAtlas textureAtlas = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS);
        this.model.setPackedLight(state.lightCoords);
        this.model.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        this.model.set(Direction.UP, new CuboidModel.Face(this.model).setSprite(textureAtlas.getSprite(this.getTopTextureLocation())).setSize(16));
        this.model.set(Direction.DOWN, new CuboidModel.Face(this.model).setSprite(textureAtlas.getSprite(BOTTOM_TEXTURE_LOCATION)).setSize(16));
        RenderType renderType = RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        collector.submitCustomGeometry(poseStack, renderType, (pose, vertexConsumer) -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Boolean isConnected = state.directionConnections.get(direction);
                this.model.set(direction, new CuboidModel.Face(this.model).setSprite(textureAtlas.getSprite(isConnected != false ? CONNECTED_SIDE_TEXTURE_LOCATION : SIDE_TEXTURE_LOCATION)).setSize(16));
            }
            CuboidModelRenderer.render(this.model, pose, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        });
        collector.submitCustomGeometry(poseStack, renderType, (pose, vertexConsumer) -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (state.directionConnections.get(direction).booleanValue()) {
                    this.model.disable(direction);
                    continue;
                }
                SignalAspect aspect = state.directionSignalAspects.get(direction);
                int skyLight = LightTexture.sky((int)state.lightCoords);
                int facePackedLight = LightTexture.pack((int)aspect.getLampLight(), (int)skyLight);
                this.model.set(direction, new CuboidModel.Face(this.model).setSprite(textureAtlas.getSprite(ASPECT_TEXTURE_LOCATIONS.get((Object)aspect))).setSize(16).setPackedLight(facePackedLight).setPackedOverlay(OverlayTexture.NO_OVERLAY));
            }
            CuboidModelRenderer.render(this.model, pose, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        });
    }

    public AABB getRenderBoundingBox(AbstractSignalBoxBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
    }
}

