/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.renderer.blockentity.FluidManipulatorRenderer;
import mods.railcraft.client.renderer.blockentity.state.FluidLoaderRenderState;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.world.level.block.entity.manipulator.FluidLoaderBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FluidLoaderRenderer
extends FluidManipulatorRenderer<FluidLoaderBlockEntity, FluidLoaderRenderState> {
    private static final float PIPE_OFFSET = 0.3125f;
    private static final ResourceLocation PIPE_SIDE_TEXTURE_LOCATION = RailcraftConstants.rl("entity/fluid_loader/pipe_side");
    private static final ResourceLocation PIPE_END_TEXTURE_LOCATION = RailcraftConstants.rl("entity/fluid_loader/pipe_end");
    private static final CuboidModel PIPE_MODEL = new CuboidModel(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.0625f, 0.6875f);

    public FluidLoaderRenderState createRenderState() {
        return new FluidLoaderRenderState();
    }

    @Override
    public void extractRenderState(FluidLoaderBlockEntity blockEntity, FluidLoaderRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        renderState.pipeLength = blockEntity.getPipeLength(partialTick);
    }

    @Override
    public void submit(FluidLoaderRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        super.submit(state, poseStack, collector, cameraState);
        TextureAtlas textureAtlas = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS);
        CuboidModel.Face sideFace = new CuboidModel.Face(PIPE_MODEL).setSprite(textureAtlas.getSprite(PIPE_SIDE_TEXTURE_LOCATION));
        PIPE_MODEL.set(Direction.NORTH, sideFace);
        PIPE_MODEL.set(Direction.SOUTH, sideFace);
        PIPE_MODEL.set(Direction.EAST, sideFace);
        PIPE_MODEL.set(Direction.WEST, sideFace);
        CuboidModel.Face endFace = new CuboidModel.Face(PIPE_MODEL).setSprite(textureAtlas.getSprite(PIPE_END_TEXTURE_LOCATION));
        PIPE_MODEL.set(Direction.UP, endFace);
        PIPE_MODEL.set(Direction.DOWN, endFace);
        PIPE_MODEL.setPackedLight(state.lightCoords);
        PIPE_MODEL.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        poseStack.pushPose();
        PIPE_MODEL.setMinY(0.0625f - state.pipeLength);
        collector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), (pose, vertexConsumer) -> CuboidModelRenderer.render(PIPE_MODEL, pose, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false));
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(FluidLoaderBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)(pos.getY() - 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
    }
}

