/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.client.renderer.blockentity.state.RitualBlockRenderState;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RitualBlock;
import mods.railcraft.world.level.block.entity.RitualBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class RitualBlockRenderer
implements BlockEntityRenderer<RitualBlockEntity, RitualBlockRenderState> {
    private final ItemModelResolver itemModelResolver;

    public RitualBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public RitualBlockRenderState createRenderState() {
        return new RitualBlockRenderState();
    }

    public void extractRenderState(RitualBlockEntity blockEntity, RitualBlockRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        renderState.yOffset = blockEntity.getYOffset(partialTick);
        renderState.yaw = blockEntity.getRotationYaw(partialTick);
        renderState.id = (int)blockEntity.getBlockPos().asLong();
        ItemStack firestone = new ItemStack((Boolean)blockEntity.getBlockState().getValue((Property)RitualBlock.CRACKED) != false ? (ItemLike)RailcraftItems.CRACKED_FIRESTONE.get() : (ItemLike)RailcraftItems.REFINED_FIRESTONE.get());
        this.itemModelResolver.updateForTopItem(renderState.itemState, firestone, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, renderState.id);
    }

    public void submit(RitualBlockRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.95f + state.yOffset, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation(state.yaw));
        poseStack.scale(0.6f, 0.6f, 0.6f);
        state.itemState.submit(poseStack, collector, state.lightCoords, OverlayTexture.NO_OVERLAY, state.id);
        poseStack.popPose();
    }
}

