/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.AbstractSignalRenderer;
import mods.railcraft.client.renderer.blockentity.state.SignalRenderState;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignalRenderer
extends AbstractSignalRenderer<AbstractSignalBlockEntity, SignalRenderState> {
    public SignalRenderState createRenderState() {
        return new SignalRenderState();
    }

    @Override
    public void extractRenderState(AbstractSignalBlockEntity blockEntity, SignalRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        renderState.direction = (Direction)blockEntity.getBlockState().getValue(SignalBlock.FACING);
        renderState.signalAspect = blockEntity.getPrimarySignalAspect().getDisplayAspect();
    }

    @Override
    public void submit(SignalRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        super.submit(state, poseStack, collector, cameraState);
        Direction direction = state.direction;
        SignalAspect signalAspect = state.signalAspect;
        poseStack.pushPose();
        double zOffset = -0.175;
        poseStack.translate(zOffset * (double)direction.getStepX(), 0.19, zOffset * (double)direction.getStepZ());
        this.renderSignalAspect(state, poseStack, collector, cameraState, signalAspect, direction);
        poseStack.popPose();
    }
}

