/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.client.renderer.RailcraftRenderTypes;
import mods.railcraft.client.renderer.blockentity.state.SteamTurbineRenderState;
import mods.railcraft.world.level.block.SteamTurbineBlock;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SteamTurbineRenderer
implements BlockEntityRenderer<SteamTurbineBlockEntity, SteamTurbineRenderState> {
    public SteamTurbineRenderState createRenderState() {
        return new SteamTurbineRenderState();
    }

    public void extractRenderState(SteamTurbineBlockEntity blockEntity, SteamTurbineRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        MultiblockBlockEntity.UnresolvedMembership membership = blockEntity.getUnresolvedMembership().orElse(null);
        if (membership == null || membership.patternElement().marker() != 'W') {
            return;
        }
        float xx = 0.0f;
        float zz = 0.0f;
        int fx = 0;
        int fz = 0;
        int rx = 0;
        int rz = 0;
        BlockPos patternPos = membership.patternElement().relativePos();
        if (((Boolean)blockEntity.getBlockState().getValue(SteamTurbineBlock.ROTATED)).booleanValue()) {
            if (patternPos.getX() == 0) {
                fx = -1;
                rz = 1;
            } else if (patternPos.getX() == 1) {
                xx += 1.0f;
                zz += 1.0f;
                fx = 1;
                rz = -1;
            }
        } else if (patternPos.getZ() == 0) {
            xx += 1.0f;
            fz = -1;
            rx = -1;
        } else if (patternPos.getZ() == 1) {
            zz += 1.0f;
            fz = 1;
            rx = 1;
        }
        if (fx == 0 && fz == 0) {
            throw new IllegalStateException("can't detect gauge orientation");
        }
        renderState.lightCoords = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().offset(fx, 0, fz));
        renderState.gaugeValue = blockEntity.getAndSmoothGaugeValue();
        renderState.xx = xx;
        renderState.rx = rx;
        renderState.fx = fx;
        renderState.zz = zz;
        renderState.rz = rz;
        renderState.fz = fz;
    }

    public void submit(SteamTurbineRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        float halfWidth = 0.03125f;
        float len = 0.26f;
        float zOffset = 0.00390625f;
        float value = state.gaugeValue;
        float angle = (90.0f * value + 45.0f) * ((float)Math.PI / 180);
        poseStack.pushPose();
        poseStack.translate((double)state.xx + (double)state.rx * 0.5 + (double)((float)state.fx * zOffset), 0.5, (double)state.zz + (double)state.rz * 0.5 + (double)((float)state.fz * zOffset));
        float cosA = Mth.cos((float)angle);
        float sinA = Mth.sin((float)angle);
        float glx = cosA * len;
        float gly = sinA * len;
        float gwx = sinA * halfWidth;
        float gwy = cosA * halfWidth;
        float baseOffset = 1.0f / Mth.sin((float)angle) * halfWidth;
        int red = 100;
        int green = 0;
        int blue = 0;
        int alphaOne = 255;
        collector.submitCustomGeometry(poseStack, RailcraftRenderTypes.POSITION_COLOR_LIGHTMAP, (pose, vertexConsumer) -> {
            vertexConsumer.addVertex(pose, (float)(-state.rx) * baseOffset, 0.0f, (float)(-state.rz) * baseOffset).setColor(red, green, blue, alphaOne).setUv(0.0f, 1.0f).setLight(state.lightCoords);
            vertexConsumer.addVertex(pose, (float)state.rx * baseOffset, 0.0f, (float)state.rz * baseOffset).setColor(red, green, blue, alphaOne).setUv(1.0f, 1.0f).setLight(state.lightCoords);
            vertexConsumer.addVertex(pose, (float)(-state.rx) * glx + (float)state.rx * gwx, gly + gwy, (float)(-state.rz) * glx + (float)state.rz * gwx).setColor(red, green, blue, alphaOne).setUv(1.0f, 0.0f).setLight(state.lightCoords);
            vertexConsumer.addVertex(pose, (float)(-state.rx) * glx - (float)state.rx * gwx, gly - gwy, (float)(-state.rz) * glx - (float)state.rz * gwx).setColor(red, green, blue, alphaOne).setUv(0.0f, 0.0f).setLight(state.lightCoords);
        });
        poseStack.popPose();
    }
}

