/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.api.carts.TunnelBoreHead;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.model.TunnelBoreModel;
import mods.railcraft.client.renderer.entity.state.TunnelBoreRendererState;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class TunnelBoreRenderer
extends EntityRenderer<TunnelBore, TunnelBoreRendererState> {
    private static final ResourceLocation TEXTURE = RailcraftConstants.rl("textures/entity/tunnel_bore/tunnel_bore.png");
    protected TunnelBoreModel modelTunnelBore;

    public TunnelBoreRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.modelTunnelBore = new TunnelBoreModel(context.bakeLayer(RailcraftModelLayers.TUNNEL_BORE));
    }

    public void submit(TunnelBoreRendererState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        boolean ghostTrain;
        poseStack.pushPose();
        long i = state.offsetSeed;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.translate(f, f1, f2);
        float yaw = state.yRot;
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        float roll = state.hurtTime;
        if (roll > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.sin((float)roll) * roll * state.damageTime / 10.0f * (float)state.hurtDir));
        }
        float colorIntensity = (ghostTrain = Seasons.isGhostTrain(state)) ? 0.5f : 1.0f;
        TunnelBoreHead head = state.head;
        this.modelTunnelBore.setRenderBoreHead(head != null);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.modelTunnelBore.setBoreHeadRotation(state.rotationAngle);
        this.modelTunnelBore.setBoreActive(state.isMinecartPowered);
        ResourceLocation textureLocation = head != null ? head.getTextureLocation() : TEXTURE;
        collector.submitModel((Model)this.modelTunnelBore, (Object)state, poseStack, this.modelTunnelBore.renderType(textureLocation), state.lightCoords, OverlayTexture.NO_OVERLAY, ARGB.colorFromFloat((float)(ghostTrain ? 0.8f : 1.0f), (float)colorIntensity, (float)colorIntensity, (float)colorIntensity), null, 0, null);
        poseStack.popPose();
    }

    public void extractRenderState(TunnelBore entity, TunnelBoreRendererState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = entity.getXRot(partialTick);
        reusedState.yRot = entity.getYRot(partialTick);
        reusedState.head = entity.getBoreHead();
        reusedState.rotationAngle = entity.getBoreRotationAngle();
        reusedState.isMinecartPowered = entity.isMinecartPowered();
    }

    public TunnelBoreRendererState createRenderState() {
        return new TunnelBoreRendererState();
    }
}

