/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.client.util.SimpleLineRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public interface LineRenderer {
    public static LineRenderer simple(MultiBufferSource bufferSource) {
        return new SimpleLineRenderer(bufferSource.getBuffer(RenderType.lines()));
    }

    public static LineRenderer simple(VertexConsumer vertexConsumer) {
        return new SimpleLineRenderer(vertexConsumer);
    }

    default public void renderLine(PoseStack poseStack, int color, Vec3 from, Vec3 to) {
        poseStack.pushPose();
        this.renderLine(poseStack.last(), ARGB.red((int)color), ARGB.green((int)color), ARGB.blue((int)color), ARGB.alpha((int)color), (float)from.x, (float)from.y, (float)from.z, (float)to.x, (float)to.y, (float)to.z);
        poseStack.popPose();
    }

    default public void renderLine(PoseStack poseStack, int color, Vector3f from, Vector3f to) {
        poseStack.pushPose();
        this.renderLine(poseStack.last(), ARGB.red((int)color), ARGB.green((int)color), ARGB.blue((int)color), ARGB.alpha((int)color), from.x, from.y, from.z, to.x, to.y, to.z);
        poseStack.popPose();
    }

    public void renderLine(PoseStack.Pose var1, int var2, int var3, int var4, int var5, float var6, float var7, float var8, float var9, float var10, float var11);
}

