/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.loot;

import java.util.concurrent.CompletableFuture;
import mods.railcraft.data.loot.packs.RailcraftChestLoot;
import mods.railcraft.loot.DungeonLootModifier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class RailcraftLootModifierProvider
extends GlobalLootModifierProvider {
    public RailcraftLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "railcraft");
    }

    protected void start() {
        this.add((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT, RailcraftChestLoot.ABANDONED_MINESHAFT);
        this.add((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON, RailcraftChestLoot.SIMPLE_DUNGEON);
        this.add((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR, RailcraftChestLoot.SIMPLE_DUNGEON);
        this.add((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CROSSING, RailcraftChestLoot.SIMPLE_DUNGEON);
        this.add((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_ARMORER, RailcraftChestLoot.SIMPLE_DUNGEON);
    }

    private void add(ResourceKey<LootTable> targetLootTable, ResourceKey<LootTable> customLootTable) {
        this.add(targetLootTable.location().getPath(), (IGlobalLootModifier)new DungeonLootModifier(this.getCondition(targetLootTable.location()), customLootTable), new ICondition[0]);
    }

    private LootItemCondition[] getCondition(ResourceLocation lootTable) {
        LootTableIdCondition.Builder condition = LootTableIdCondition.builder((ResourceLocation)lootTable);
        return new LootItemCondition[]{condition.build()};
    }
}

