/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.AbstractCookingRecipeBuilder;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceRecipeBuilder
extends AbstractCookingRecipeBuilder {
    public static final int DEFAULT_COOKING_TIME = 400;
    private final int slagOutput;

    private BlastFurnaceRecipeBuilder(ItemLike result, int count, Ingredient ingredient, float experience, int cookingTime, int slagOutput) {
        super(result, count, ingredient, experience, cookingTime);
        this.slagOutput = slagOutput;
    }

    public static BlastFurnaceRecipeBuilder smelting(ItemLike result, int count, Ingredient ingredient, int multiplier, int slagOutput) {
        return new BlastFurnaceRecipeBuilder(result, count, ingredient, 0.0f, 400 * multiplier, slagOutput);
    }

    public static BlastFurnaceRecipeBuilder smelting(ItemLike result, Ingredient ingredient, int multiplier, int slagOutput) {
        return new BlastFurnaceRecipeBuilder((ItemLike)result.asItem(), multiplier, ingredient, 0.0f, 400 * multiplier, slagOutput);
    }

    public static BlastFurnaceRecipeBuilder recycling(ItemLike result, Ingredient ingredient, int multiplier) {
        return new BlastFurnaceRecipeBuilder((ItemLike)result.asItem(), multiplier, ingredient, 0.0f, 200 * multiplier, 0);
    }

    public void save(RecipeOutput recipeOutput, ResourceKey<Recipe<?>> resourceKey) {
        String path = resourceKey.location().getPath();
        ResourceLocation customResourceLocation = RailcraftConstants.rl("blast_furnace/" + path);
        ResourceKey customResourceKey = ResourceKey.create((ResourceKey)resourceKey.registryKey(), (ResourceLocation)customResourceLocation);
        ResourceLocation advancementId = customResourceLocation.withPrefix("recipes/");
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)customResourceKey)).rewards(AdvancementRewards.Builder.recipe((ResourceKey)customResourceKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        BlastFurnaceRecipe recipe = new BlastFurnaceRecipe(this.ingredient, new ItemStack((ItemLike)this.result, this.count), this.experience, this.cookingTime, this.slagOutput);
        recipeOutput.accept(customResourceKey, (Recipe)recipe, builder.build(advancementId));
    }
}

