/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;

public class BrewingRecipe
implements IBrewingRecipe {
    private final Holder<Potion> input;
    private final Holder<Potion> output;
    private final Item ingredient;

    public BrewingRecipe(Holder<Potion> input, Item ingredient, Holder<Potion> output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
    }

    public boolean isInput(ItemStack input) {
        PotionContents potionContent = (PotionContents)input.get(DataComponents.POTION_CONTENTS);
        if (potionContent != null) {
            return potionContent.is(this.input);
        }
        return false;
    }

    public boolean isIngredient(ItemStack ingredient) {
        return ingredient.getItem().equals(this.ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (!this.isInput(input) || !this.isIngredient(ingredient)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = new ItemStack((ItemLike)input.getItem());
        itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(this.output));
        return itemStack;
    }
}

