/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.providers;

import java.util.concurrent.CompletableFuture;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.BlastFurnaceRecipeBuilder;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class BlastFurnaceRecipeProvider
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    private BlastFurnaceRecipeProvider(HolderLookup.Provider registries, RecipeOutput recipeOutput) {
        super(registries, recipeOutput);
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        BlastFurnaceRecipeBuilder.smelting((ItemLike)RailcraftBlocks.STEEL_BLOCK.get(), 1, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.STORAGE_BLOCKS_IRON)), 9, 9).unlockedBy("has_iron_block", this.has(Tags.Items.STORAGE_BLOCKS_IRON)).save(this.output, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName((ItemLike)RailcraftItems.STEEL_BLOCK.get()).toString());
        BlastFurnaceRecipeBuilder.smelting((ItemLike)RailcraftItems.STEEL_INGOT.get(), Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_IRON)), 1, 1).unlockedBy("has_iron_ingots", this.has(Tags.Items.INGOTS_IRON)).save(this.output, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName((ItemLike)Items.IRON_INGOT).toString());
        this.consumeIronSteelItems();
    }

    private void consumeIronSteelItems() {
        this.blastFurnaceSmelting((ItemLike)Items.BUCKET, 3);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_HELMET, 5);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_CHESTPLATE, 8);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_LEGGINGS, 7);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_BOOTS, 4);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_HORSE_ARMOR, 4);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_SWORD, 2);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_SHOVEL, 1);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_PICKAXE, 3);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_AXE, 3);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_HOE, 2);
        this.blastFurnaceSmelting((ItemLike)Items.SHEARS, 2);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_DOOR, 2);
        this.blastFurnaceSmelting((ItemLike)Items.IRON_TRAPDOOR, 4);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_HELMET.get(), 4);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_CHESTPLATE.get(), 7);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_LEGGINGS.get(), 6);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_BOOTS.get(), 3);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_SWORD.get(), 1);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_PICKAXE.get(), 2);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_HOE.get(), 1);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_AXE.get(), 2);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.STEEL_SHEARS.get(), 1);
        this.blastFurnaceRecycling((ItemLike)RailcraftItems.IRON_CROWBAR.get(), 2);
    }

    private void blastFurnaceSmelting(ItemLike item, int multiplier) {
        BlastFurnaceRecipeBuilder.smelting((ItemLike)RailcraftItems.STEEL_INGOT.get(), Ingredient.of((ItemLike)item), multiplier, multiplier).unlockedBy(BlastFurnaceRecipeProvider.getHasName((ItemLike)item), this.has(item)).save(this.output, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName(item).toString());
    }

    private void blastFurnaceRecycling(ItemLike item, int multiplier) {
        BlastFurnaceRecipeBuilder.recycling((ItemLike)RailcraftItems.STEEL_INGOT.get(), Ingredient.of((ItemLike)item), multiplier).unlockedBy(BlastFurnaceRecipeProvider.getHasName((ItemLike)item), this.has(item)).save(this.output, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName(item).toString());
    }

    private static ResourceLocation getRailcraftBlastingRecipeName(ItemLike item) {
        String tag = BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
        return RailcraftConstants.rl("blasting_" + tag);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new BlastFurnaceRecipeProvider(registries, output);
        }

        public String getName() {
            return "BlastFurnaceRecipeProvider";
        }
    }
}

