/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.providers;

import java.util.concurrent.CompletableFuture;
import mods.railcraft.data.recipes.builders.CrusherRecipeBuilder;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.DecorativeBlock;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class CrusherRecipeProvider
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    private CrusherRecipeProvider(HolderLookup.Provider registries, RecipeOutput recipeOutput) {
        super(registries, recipeOutput);
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.buildVanilla();
        this.buildRailcraft();
        this.buildConditionalRecipe();
    }

    private void buildVanilla() {
        CrusherRecipeBuilder.crush((ItemLike)Items.OBSIDIAN).addResult((ItemLike)RailcraftItems.CRUSHED_OBSIDIAN, 1, 1.0).addResult((ItemLike)RailcraftItems.OBSIDIAN_DUST, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.COBBLESTONE).addResult((ItemLike)Items.GRAVEL, 1, 1.0).addResult((ItemLike)Items.FLINT, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.MOSSY_COBBLESTONE).addResult((ItemLike)Items.GRAVEL, 1, 1.0).addResult((ItemLike)Items.VINE, 1, 0.8).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.GRAVEL).addResult((ItemLike)Items.SAND, 1, 1.0).addResult((ItemLike)Items.GOLD_NUGGET, 1, 0.001).addResult((ItemLike)Items.DIAMOND, 1, 5.0E-5).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.STONES).addResult((ItemLike)Items.COBBLESTONE, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.SANDSTONE_BLOCKS).addResult((ItemLike)Items.SAND, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.BRICKS).addResult((ItemLike)Items.BRICK, 3, 1.0).addResult((ItemLike)Items.BRICK, 1, 0.5).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.CLAY).addResult((ItemLike)Items.CLAY_BALL, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)ItemTags.STONE_BRICKS).addResult((ItemLike)Items.COBBLESTONE, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.COBBLESTONE_STAIRS).addResult((ItemLike)Items.GRAVEL, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.STONE_BRICK_STAIRS).addResult((ItemLike)Items.COBBLESTONE, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.NETHER_BRICK_STAIRS).addResult((ItemLike)Items.NETHER_BRICK, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.BRICK_STAIRS).addResult((ItemLike)Items.BRICK, 4, 1.0).addResult((ItemLike)Items.BRICK, 1, 0.5).addResult((ItemLike)Items.BRICK, 1, 0.5).save(this.output);
        CrusherRecipeBuilder.crush(Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_SLAB, Items.STONE_BRICK_SLAB})).addResult((ItemLike)Items.COBBLESTONE, 1, 0.45).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.SANDSTONE_SLAB).addResult((ItemLike)Items.SAND, 1, 0.45).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.COBBLESTONE_SLAB).addResult((ItemLike)Items.GRAVEL, 1, 0.45).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.BRICK_SLAB).addResult((ItemLike)Items.BRICK, 1, 1.0).addResult((ItemLike)Items.BRICK, 1, 0.75).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.ICE).addResult((ItemLike)Items.SNOW_BLOCK, 1, 0.85).addResult((ItemLike)Items.SNOWBALL, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.NETHER_BRICK_FENCE).addResult((ItemLike)Items.NETHER_BRICK, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.GLOWSTONE).addResult((ItemLike)Items.GLOWSTONE_DUST, 3, 1.0).addResult((ItemLike)Items.GLOWSTONE_DUST, 1, 0.75).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.REDSTONE_LAMP).addResult((ItemLike)Items.GLOWSTONE_DUST, 3, 1.0).addResult((ItemLike)Items.GLOWSTONE_DUST, 1, 0.75).addResult((ItemLike)Items.REDSTONE, 3, 1.0).addResult((ItemLike)Items.REDSTONE, 1, 0.75).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.BONE).addResult((ItemLike)Items.BONE_MEAL, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.BLAZE_ROD).addResult((ItemLike)Items.BLAZE_POWDER, 2, 1.0).addResult((ItemLike)Items.BLAZE_POWDER, 1, 0.65).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 1, 0.5).addResult((ItemLike)Items.BLAZE_POWDER, 1, 0.25).addResult((ItemLike)Items.BLAZE_POWDER, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_REDSTONE).addResult((ItemLike)Items.REDSTONE, 6, 1.0).addResult((ItemLike)Items.REDSTONE, 2, 0.85).addResult((ItemLike)Items.REDSTONE, 1, 0.25).addResult((ItemLike)Items.GLOWSTONE_DUST, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_DIAMOND).addResult((ItemLike)Items.DIAMOND, 1, 1.0).addResult((ItemLike)Items.DIAMOND, 1, 0.85).addResult((ItemLike)Items.DIAMOND, 1, 0.25).addResult((ItemLike)Items.COAL, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_EMERALD).addResult((ItemLike)Items.EMERALD, 1, 1.0).addResult((ItemLike)Items.EMERALD, 1, 0.85).addResult((ItemLike)Items.EMERALD, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_LAPIS).addResult((ItemLike)Items.LAPIS_LAZULI, 8, 1.0).addResult((ItemLike)Items.LAPIS_LAZULI, 1, 0.85).addResult((ItemLike)Items.LAPIS_LAZULI, 1, 0.35).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 1, 0.2).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_COAL).addResult((ItemLike)RailcraftItems.COAL_DUST, 2, 1.0).addResult((ItemLike)RailcraftItems.COAL_DUST, 1, 0.65).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 1, 0.15).addResult((ItemLike)Items.COAL, 1, 0.15).addResult((ItemLike)Items.DIAMOND, 1, 0.001).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.COAL).addResult((ItemLike)RailcraftItems.COAL_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.CHARCOAL).addResult((ItemLike)RailcraftItems.CHARCOAL_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.COAL_BLOCK).addResult((ItemLike)RailcraftItems.COAL_DUST, 9, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.ENDER_PEARL).addResult((ItemLike)RailcraftItems.ENDER_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_QUARTZ).addResult((ItemLike)Items.QUARTZ, 3, 1.0).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.DARK_PRISMARINE).addResult((ItemLike)Items.PRISMARINE_SHARD, 8, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.PRISMARINE_BRICKS).addResult((ItemLike)Items.PRISMARINE_SHARD, 9, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.PRISMARINE).addResult((ItemLike)Items.PRISMARINE_SHARD, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.AMETHYST_BLOCK).addResult((ItemLike)Items.AMETHYST_SHARD, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.NETHER_WART_BLOCK).addResult((ItemLike)Items.NETHER_WART, 9, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)ItemTags.WOOL).addResult((ItemLike)Items.STRING, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.QUARTZ_BLOCK).addResult((ItemLike)Items.QUARTZ, 4, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.RAW_IRON_BLOCK).addResult((ItemLike)Items.RAW_IRON, 9, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_RAW_COPPER).addResult((ItemLike)Items.RAW_COPPER, 9, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.RAW_GOLD_BLOCK).addResult((ItemLike)Items.RAW_GOLD, 9, 1.0).save(this.output);
    }

    private void buildRailcraft() {
        CrusherRecipeBuilder.crush(RailcraftItems.COKE_OVEN_BRICKS).addResult((ItemLike)Items.BRICK, 3, 1.0).addResult((ItemLike)Items.BRICK, 1, 0.5).addResult((ItemLike)Items.SAND, 1, 0.25).addResult((ItemLike)Items.SAND, 1, 0.25).addResult((ItemLike)Items.SAND, 1, 0.25).addResult((ItemLike)Items.SAND, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush(RailcraftItems.BLAST_FURNACE_BRICKS).addResult((ItemLike)Items.NETHER_BRICK, 1, 0.75).addResult((ItemLike)Items.SOUL_SAND, 1, 0.75).addResult((ItemLike)Items.BLAZE_POWDER, 1, 0.05).save(this.output);
        CrusherRecipeBuilder.crush(RailcraftItems.CRUSHED_OBSIDIAN).addResult((ItemLike)RailcraftItems.OBSIDIAN_DUST, 1, 1.0).addResult((ItemLike)RailcraftItems.OBSIDIAN_DUST, 1, 0.25).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.SULFUR_ORE).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 5, 1.0).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 1, 0.85).addResult((ItemLike)RailcraftItems.SULFUR_DUST, 1, 0.35).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.SALTPETER_ORE).addResult((ItemLike)RailcraftItems.SALTPETER_DUST, 3, 1.0).addResult((ItemLike)RailcraftItems.SALTPETER_DUST, 1, 0.85).addResult((ItemLike)RailcraftItems.SALTPETER_DUST, 1, 0.35).save(this.output);
        CrusherRecipeBuilder.crush(RailcraftItems.FIRESTONE_ORE).addResult((ItemLike)RailcraftItems.RAW_FIRESTONE, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.QUARRIED).addResult((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(DecorativeBlock.QUARRIED).get(), 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.ABYSSAL).addResult((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(DecorativeBlock.ABYSSAL).get(), 1, 1.0).save(this.output);
        for (DecorativeBlock type : DecorativeBlock.values()) {
            CrusherRecipeBuilder.crush(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.DECORATIVE_BRICK_STAIRS.variantFor(type).get(), (ItemLike)RailcraftItems.DECORATIVE_PAVER_STAIRS.variantFor(type).get()})).addResult((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get(), 1, 0.75).save(this.output);
            CrusherRecipeBuilder.crush(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.DECORATIVE_BRICK_SLAB.variantFor(type).get(), (ItemLike)RailcraftItems.DECORATIVE_PAVER_SLAB.variantFor(type).get()})).addResult((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get(), 1, 0.5).save(this.output);
        }
        CrusherRecipeBuilder.crush(Ingredient.of((ItemLike[])new ItemLike[]{RailcraftItems.ZINC_SILVER_BATTERY_EMPTY, RailcraftItems.ZINC_CARBON_BATTERY_EMPTY})).addResult((ItemLike)RailcraftItems.CHARGE_TERMINAL, 2, 1.0).addResult((ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM, 1, 1.0).addResult((ItemLike)RailcraftItems.SLAG, 4, 1.0).addResult((ItemLike)RailcraftItems.SLAG, 2, 0.5).save(this.output);
        CrusherRecipeBuilder.crush(Ingredient.of((ItemLike[])new ItemLike[]{RailcraftItems.PERSONAL_WORLD_SPIKE, RailcraftItems.WORLD_SPIKE})).addResult((ItemLike)RailcraftItems.CRUSHED_OBSIDIAN.get(), 1, 1.0).addResult((ItemLike)RailcraftItems.CRUSHED_OBSIDIAN.get(), 1, 0.5).addResult((ItemLike)Items.OBSIDIAN, 1, 0.25).addResult((ItemLike)RailcraftItems.OBSIDIAN_DUST.get(), 1, 0.25).addResult((ItemLike)Items.GOLD_NUGGET, 16, 1.0).addResult((ItemLike)Items.GOLD_NUGGET, 8, 0.5).addResult((ItemLike)Items.GOLD_NUGGET, 8, 0.5).addResult((ItemLike)Items.GOLD_NUGGET, 4, 0.5).addResult((ItemLike)Items.EMERALD, 1, 0.5).save(this.output);
    }

    private void buildConditionalRecipe() {
        CrusherRecipeBuilder.crush((ItemLike)Items.NETHERITE_INGOT).addResult(this.items, RailcraftTags.Items.NETHERITE_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.BRONZE_INGOT).addResult(this.items, RailcraftTags.Items.BRONZE_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush((ItemLike)Items.LAPIS_LAZULI).addResult(this.items, RailcraftTags.Items.LAPIS_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.GEMS_QUARTZ).addResult(this.items, RailcraftTags.Items.QUARTZ_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.GEMS_EMERALD).addResult(this.items, RailcraftTags.Items.EMERALD_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.GEMS_DIAMOND).addResult(this.items, RailcraftTags.Items.DIAMOND_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.STEEL_INGOT).addResult(this.items, RailcraftTags.Items.STEEL_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.INGOTS_IRON).addResult(this.items, RailcraftTags.Items.IRON_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_RAW_IRON).addResult(this.items, RailcraftTags.Items.IRON_DUST, 12, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_IRON).addResult(this.items, RailcraftTags.Items.IRON_DUST, 2, 1.0).addResult(this.items, RailcraftTags.Items.NICKEL_DUST, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON).addResult(this.items, RailcraftTags.Items.IRON_DUST, 1, 1.0).addResult(this.items, RailcraftTags.Items.IRON_DUST, 1, 0.35).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.INGOTS_GOLD).addResult(this.items, RailcraftTags.Items.GOLD_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_GOLD).addResult(this.items, RailcraftTags.Items.GOLD_DUST, 2, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_RAW_GOLD).addResult(this.items, RailcraftTags.Items.GOLD_DUST, 12, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.INGOTS_COPPER).addResult(this.items, RailcraftTags.Items.COPPER_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER).addResult(this.items, RailcraftTags.Items.COPPER_DUST, 1, 1.0).addResult(this.items, RailcraftTags.Items.COPPER_DUST, 1, 0.35).save(this.output);
        CrusherRecipeBuilder.crush(this.items, (TagKey<Item>)Tags.Items.ORES_COPPER).addResult(this.items, RailcraftTags.Items.COPPER_DUST, 2, 1.0).addResult(this.items, RailcraftTags.Items.GOLD_DUST, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.TIN_INGOT).addResult(this.items, RailcraftTags.Items.TIN_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.LEAD_INGOT).addResult(this.items, RailcraftTags.Items.LEAD_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.RAW_LEAD_BLOCK).addResult(this.items, RailcraftTags.Items.LEAD_DUST, 12, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.LEAD_ORE).addResult(this.items, RailcraftTags.Items.LEAD_DUST, 2, 1.0).addResult(this.items, RailcraftTags.Items.SILVER_DUST, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.COAL_COKE).addResult(this.items, RailcraftTags.Items.COAL_COKE_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.SILVER_INGOT).addResult(this.items, RailcraftTags.Items.SILVER_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.SILVER_ORE).addResult(this.items, RailcraftTags.Items.SILVER_DUST, 2, 1.0).addResult(this.items, RailcraftTags.Items.LEAD_DUST, 1, 0.1).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.SILVER_RAW).addResult(this.items, RailcraftTags.Items.SILVER_DUST, 1, 1.0).addResult(this.items, RailcraftTags.Items.SILVER_DUST, 1, 0.35).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.RAW_SILVER_BLOCK).addResult(this.items, RailcraftTags.Items.SILVER_DUST, 12, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.NICKEL_INGOT).addResult(this.items, RailcraftTags.Items.NICKEL_DUST, 1, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.RAW_NICKEL_BLOCK).addResult(this.items, RailcraftTags.Items.NICKEL_DUST, 12, 1.0).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.NICKEL_RAW).addResult(this.items, RailcraftTags.Items.NICKEL_DUST, 1, 1.0).addResult(this.items, RailcraftTags.Items.NICKEL_DUST, 1, 0.35).save(this.output);
        CrusherRecipeBuilder.crush(this.items, RailcraftTags.Items.NICKEL_ORE).addResult(this.items, RailcraftTags.Items.NICKEL_DUST, 2, 1.0).save(this.output);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new CrusherRecipeProvider(registries, output);
        }

        public String getName() {
            return "CrusherRecipeProvider";
        }
    }
}

