/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class DefaultRecipeWrapper<T extends CraftingRecipe>
implements ICraftingCategoryExtension<T> {
    private final boolean isShapeless;
    private final Component info;
    private Consumer<ItemStack> stackModifier;

    DefaultRecipeWrapper(boolean isShapeless) {
        this(isShapeless, (Component)Component.empty());
    }

    DefaultRecipeWrapper(boolean isShapeless, Component info) {
        this.isShapeless = isShapeless;
        this.info = info;
        this.stackModifier = stack -> {};
    }

    DefaultRecipeWrapper<T> modifyInputs(Consumer<ItemStack> stackModifier) {
        this.stackModifier = stackModifier;
        return this;
    }

    public void drawInfo(RecipeHolder<T> recipe, int recipeWidth, int recipeHeight, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        int stringWidth = font.width((FormattedText)this.info) / 2;
        guiGraphics.drawString(font, this.info, 82 - stringWidth, 0, -8355712, false);
    }

    public List<SlotDisplay> getIngredients(RecipeHolder<T> recipeHolder) {
        List displays = ((CraftingRecipe)recipeHolder.value()).display();
        if (displays.isEmpty()) {
            return List.of();
        }
        RecipeDisplay recipeDisplay = (RecipeDisplay)displays.getFirst();
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay2, n)) {
            case 0 -> {
                ShapedCraftingRecipeDisplay shapedDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay2;
                yield shapedDisplay.ingredients();
            }
            case 1 -> {
                ShapelessCraftingRecipeDisplay shapelessDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                yield shapelessDisplay.ingredients();
            }
            default -> List.of();
        };
    }

    public int getWidth(RecipeHolder<T> recipeHolder) {
        return this.isShapeless ? 0 : 3;
    }

    public int getHeight(RecipeHolder<T> recipeHolder) {
        return this.isShapeless ? 0 : 3;
    }
}

