/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.level.ItemLike;

public class CokeOvenRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<CokeOvenRecipe>> {
    private static final int WIDTH = 127;
    private static final int HEIGHT = 49;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/coke_oven.png");
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable flame;
    private final IDrawable arrow;

    public CokeOvenRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.COKE_OVEN, (Component)Component.translatable((String)Translations.Jei.COKE_OVEN), guiHelper.createDrawableItemLike((ItemLike)RailcraftItems.COKE_OVEN_BRICKS.get()), 127, 49);
        this.tankBackground = guiHelper.createDrawable(BACKGROUND, 89, 23, 50, 49);
        this.tankOverlay = guiHelper.createDrawable(BACKGROUND, 176, 0, 48, 47);
        this.flame = guiHelper.createAnimatedRecipeFlame(200);
        this.arrow = guiHelper.createAnimatedRecipeArrow(200);
    }

    public void draw(RecipeHolder<CokeOvenRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 1, 3);
        this.arrow.draw(guiGraphics, 20, 21);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<CokeOvenRecipe> recipeHolder, IFocusGroup focuses) {
        FurnaceRecipeDisplay furnaceRecipeDisplay;
        int cookTime;
        CokeOvenRecipe recipe = (CokeOvenRecipe)recipeHolder.value();
        Object e = recipe.display().getFirst();
        if (e instanceof FurnaceRecipeDisplay && (cookTime = (furnaceRecipeDisplay = (FurnaceRecipeDisplay)e).duration()) > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            builder.addText((FormattedText)timeString, 57, 50).setTextAlignment(VerticalAlignment.BOTTOM).setTextAlignment(HorizontalAlignment.CENTER).setColor(-8355712);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CokeOvenRecipe> recipeHolder, IFocusGroup focuses) {
        CokeOvenRecipe recipe = (CokeOvenRecipe)recipeHolder.value();
        Ingredient ingredients = recipe.input();
        builder.addInputSlot(1, 20).setStandardSlotBackground().add(ingredients);
        builder.addOutputSlot(49, 20).setOutputSlotBackground().add(recipe.assemble(null, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        ((IRecipeSlotBuilder)builder.addOutputSlot(78, 1).add((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getCreosote())).setFluidRenderer(10000L, true, 48, 47).setOverlay(this.tankOverlay, 0, 0).setBackground(this.tankBackground, -1, -1);
    }
}

