/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RollingRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;

public class RollingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<RollingRecipe>> {
    private static final int WIDTH = 116;
    private static final int HEIGHT = 54;
    private final ICraftingGridHelper craftingGridHelper;

    public RollingRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.ROLLING_MACHINE, (Component)Component.translatable((String)Translations.Jei.METAL_ROLLING), guiHelper.createDrawableItemLike((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get()), 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RollingRecipe> recipeHolder, IFocusGroup focuses) {
        RollingRecipe recipe = (RollingRecipe)recipeHolder.value();
        RecipeDisplay display = recipe.display().getFirst();
        SlotDisplay resultItem = display.result();
        this.craftingGridHelper.createAndSetOutputs(builder, resultItem);
        int width = recipe.getWidth();
        int height = recipe.getHeight();
        if (recipe.display().isEmpty()) {
            this.craftingGridHelper.createAndSetIngredientsFromDisplays(builder, List.of(), width, height);
        } else {
            RecipeDisplay recipeDisplay = display;
            Objects.requireNonNull(recipeDisplay);
            RecipeDisplay recipeDisplay2 = recipeDisplay;
            int n = 0;
            List ingredients = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)recipeDisplay2, n)) {
                case 0 -> {
                    ShapedCraftingRecipeDisplay shapedDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay2;
                    yield shapedDisplay.ingredients();
                }
                case 1 -> {
                    ShapelessCraftingRecipeDisplay shapelessDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                    yield shapelessDisplay.ingredients();
                }
                default -> List.of();
            };
            this.craftingGridHelper.createAndSetIngredientsFromDisplays(builder, ingredients, width, height);
        }
    }
}

