/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.mixin;

import java.util.Optional;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.attachment.RailcraftAttachmentTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractMinecart.class})
public class AbstractMinecartMixin {
    private AbstractMinecart self() {
        return (AbstractMinecart)this;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void railcraft$tick(CallbackInfo callbackInfo) {
        RollingStock.getOrThrow(this.self()).tick();
    }

    @Redirect(method={"comeOffTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;getMaxSpeed(Lnet/minecraft/server/level/ServerLevel;)D"))
    private double railcraft$bypassgetMaxSpeed(AbstractMinecart minecart, ServerLevel level) {
        if (minecart.onGround()) {
            return minecart.getBehavior().getMaxSpeed(level);
        }
        return ((Optional)minecart.getData(RailcraftAttachmentTypes.MAX_SPEED_AIR_LATERAL)).map(Double::valueOf).orElse(minecart.getBehavior().getMaxSpeed(level));
    }

    @Inject(method={"comeOffTrack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V")})
    private void railcraft$beforeMove(ServerLevel level, CallbackInfo ci) {
        float maxSpeedAirVertical = ((Float)this.self().getData(RailcraftAttachmentTypes.MAX_SPEED_AIR_VERTICAL)).floatValue();
        if (maxSpeedAirVertical > 0.0f && this.self().getDeltaMovement().y > (double)maxSpeedAirVertical) {
            if (Math.abs(this.self().getDeltaMovement().x) < (double)0.3f && Math.abs(this.self().getDeltaMovement().z) < (double)0.3f) {
                this.self().setDeltaMovement(new Vec3(this.self().getDeltaMovement().x, (double)0.15f, this.self().getDeltaMovement().z));
            } else {
                this.self().setDeltaMovement(new Vec3(this.self().getDeltaMovement().x, (double)maxSpeedAirVertical, this.self().getDeltaMovement().z));
            }
        }
    }

    @Redirect(method={"comeOffTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;scale(D)Lnet/minecraft/world/phys/Vec3;", ordinal=1))
    private Vec3 railcraft$fixScale(Vec3 instance, double factor) {
        return instance.scale((double)((Float)this.self().getData(RailcraftAttachmentTypes.AIR_DRAG)).floatValue());
    }
}

