/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.mixin;

import java.util.Iterator;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import net.minecraft.world.Container;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecartHopper.class})
public class MinecartHopperMixin {
    private static final int PUSH_COOLDOWN_TICKS = 5;
    private int pushTime = 5;

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void railcraft$pushItems(CallbackInfo callbackInfo) {
        MinecartHopper self = (MinecartHopper)this;
        if (!self.level().isClientSide() && self.isAlive() && this.pushTime-- == 0) {
            MinecartHopperMixin.tryPushItem(self);
            this.pushTime = 5;
        }
    }

    private static void tryPushItem(MinecartHopper self) {
        ModifiableSlotAccessor slot;
        ContainerManipulator<ModifiableSlotAccessor> manipulator = ContainerManipulator.of((Container)self);
        RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)self);
        boolean full = true;
        Iterator<ModifiableSlotAccessor> it = manipulator.containerIterator();
        while (it.hasNext()) {
            slot = it.next();
            if (slot.isFull()) {
                slot.setItem(rollingStock.pushItem(slot.item()));
            }
            if (!slot.isEmpty()) continue;
            full = false;
        }
        if (!full) {
            return;
        }
        it = manipulator.containerIterator();
        while (it.hasNext()) {
            slot = it.next();
            ItemStack left = rollingStock.pushItem(slot.item());
            slot.setItem(left);
            if (!left.isEmpty()) continue;
            return;
        }
    }
}

