/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.mixin;

import com.mojang.datafixers.util.Pair;
import mods.railcraft.api.carts.CartAdvanceable;
import mods.railcraft.attachment.RailcraftAttachmentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={OldMinecartBehavior.class})
public abstract class OldMinecartBehaviorMixin
extends MinecartBehavior {
    protected OldMinecartBehaviorMixin(AbstractMinecart minecart) {
        super(minecart);
    }

    private OldMinecartBehavior self() {
        return (OldMinecartBehavior)this;
    }

    @Unique
    private double railcraft$getCustomMaxSpeed(ServerLevel level) {
        if (!((Boolean)this.minecart.getData(RailcraftAttachmentTypes.CAN_USE_RAIL)).booleanValue()) {
            return this.self().getMaxSpeed(level);
        }
        BlockPos pos = this.railcraft$getCurrentRailPosition(this.minecart, level);
        BlockState state = level.getBlockState(pos);
        if (!state.is(BlockTags.RAILS)) {
            return this.self().getMaxSpeed(level);
        }
        float railMaxSpeed = ((BaseRailBlock)state.getBlock()).getRailMaxSpeed(state, (Level)level, pos, this.minecart);
        return Math.min(railMaxSpeed, ((Float)this.minecart.getData(RailcraftAttachmentTypes.CURRENT_SPEED_CAP_ON_RAIL)).floatValue());
    }

    @Overwrite
    public void moveAlongTrack(ServerLevel serverLevel) {
        AbstractMinecart abstractMinecart;
        double d12;
        Vec3 vec32;
        PoweredRailBlock poweredRail;
        BlockPos blockpos = this.minecart.getCurrentBlockPosOrRailBelow();
        BlockState blockstate = this.self().level().getBlockState(blockpos);
        this.minecart.resetFallDistance();
        double d0 = this.minecart.getX();
        double d1 = this.minecart.getY();
        double d2 = this.minecart.getZ();
        Vec3 vec3 = this.self().getPos(d0, d1, d2);
        d1 = blockpos.getY();
        boolean flag = false;
        boolean flag1 = false;
        Block var14 = blockstate.getBlock();
        if (var14 instanceof PoweredRailBlock && !(poweredRail = (PoweredRailBlock)var14).isActivatorRail()) {
            flag = (Boolean)blockstate.getValue((Property)PoweredRailBlock.POWERED);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.minecart.isInWater()) {
            d3 *= 0.2;
        }
        Vec3 vec31 = this.getDeltaMovement();
        RailShape railshape = ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)this.level(), blockpos, this.minecart);
        switch (railshape) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(vec31.add(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(vec31.add(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(vec31.add(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(vec31.add(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec31 = this.getDeltaMovement();
        Pair pair = AbstractMinecart.exits((RailShape)railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.getX() - vec3i.getX();
        double d5 = vec3i1.getZ() - vec3i.getZ();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec31.x * d4 + vec31.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec31.horizontalDistance());
        vec31 = new Vec3(d8 * d4 / d6, vec31.y, d8 * d5 / d6);
        this.setDeltaMovement(vec31);
        Entity entity = this.minecart.getFirstPassenger();
        Entity var33 = this.minecart.getFirstPassenger();
        if (var33 instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)var33;
            vec32 = serverplayer.getLastClientMoveIntent();
        } else {
            vec32 = Vec3.ZERO;
        }
        if (entity instanceof Player && vec32.lengthSqr() > 0.0) {
            Vec3 vec35 = vec32.normalize();
            double d22 = this.getDeltaMovement().horizontalDistanceSqr();
            if (vec35.lengthSqr() > 0.0 && d22 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(vec32.x * 0.001, 0.0, vec32.z * 0.001));
                flag1 = false;
            }
        }
        if (flag1 && this.railcraft$shouldDoRailFunctions()) {
            double d20 = this.getDeltaMovement().horizontalDistance();
            if (d20 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double d21 = (double)blockpos.getX() + 0.5 + (double)vec3i.getX() * 0.5;
        double d9 = (double)blockpos.getZ() + 0.5 + (double)vec3i.getZ() * 0.5;
        double d10 = (double)blockpos.getX() + 0.5 + (double)vec3i1.getX() * 0.5;
        double d11 = (double)blockpos.getZ() + 0.5 + (double)vec3i1.getZ() * 0.5;
        d4 = d10 - d21;
        d5 = d11 - d9;
        if (d4 == 0.0) {
            d12 = d2 - (double)blockpos.getZ();
        } else if (d5 == 0.0) {
            d12 = d0 - (double)blockpos.getX();
        } else {
            double d13 = d0 - d21;
            double d14 = d2 - d9;
            d12 = (d13 * d4 + d14 * d5) * 2.0;
        }
        d0 = d21 + d4 * d12;
        d2 = d9 + d5 * d12;
        this.setPos(d0, d1, d2);
        double d23 = this.minecart.isVehicle() ? 0.75 : 1.0;
        double d24 = this.railcraft$getCustomMaxSpeed(serverLevel);
        vec31 = this.getDeltaMovement();
        this.minecart.move(MoverType.SELF, new Vec3(Mth.clamp((double)(d23 * vec31.x), (double)(-d24), (double)d24), 0.0, Mth.clamp((double)(d23 * vec31.z), (double)(-d24), (double)d24)));
        if (vec3i.getY() != 0 && Mth.floor((double)this.minecart.getX()) - blockpos.getX() == vec3i.getX() && Mth.floor((double)this.minecart.getZ()) - blockpos.getZ() == vec3i.getZ()) {
            this.setPos(this.minecart.getX(), this.minecart.getY() + (double)vec3i.getY(), this.minecart.getZ());
        } else if (vec3i1.getY() != 0 && Mth.floor((double)this.minecart.getX()) - blockpos.getX() == vec3i1.getX() && Mth.floor((double)this.minecart.getZ()) - blockpos.getZ() == vec3i1.getZ()) {
            this.setPos(this.minecart.getX(), this.minecart.getY() + (double)vec3i1.getY(), this.minecart.getZ());
        }
        this.setDeltaMovement(this.minecart.applyNaturalSlowdown(this.getDeltaMovement()));
        Vec3 vec33 = this.self().getPos(this.minecart.getX(), this.minecart.getY(), this.minecart.getZ());
        if (vec33 != null && vec3 != null) {
            double d15 = (vec3.y - vec33.y) * 0.05;
            Vec3 vec34 = this.getDeltaMovement();
            double d16 = vec34.horizontalDistance();
            if (d16 > 0.0) {
                this.setDeltaMovement(vec34.multiply((d16 + d15) / d16, 1.0, (d16 + d15) / d16));
            }
            this.setPos(this.minecart.getX(), vec33.y, this.minecart.getZ());
        }
        int j = Mth.floor((double)this.minecart.getX());
        int i = Mth.floor((double)this.minecart.getZ());
        if (j != blockpos.getX() || i != blockpos.getZ()) {
            Vec3 vec36 = this.getDeltaMovement();
            double d25 = vec36.horizontalDistance();
            this.setDeltaMovement(d25 * (double)(j - blockpos.getX()), vec36.y, d25 * (double)(i - blockpos.getZ()));
        }
        if (this.railcraft$shouldDoRailFunctions()) {
            BaseRailBlock baserailblock = (BaseRailBlock)blockstate.getBlock();
            baserailblock.onMinecartPass(blockstate, this.level(), blockpos, this.minecart);
        }
        if (flag && this.railcraft$shouldDoRailFunctions()) {
            Vec3 vec37 = this.getDeltaMovement();
            double d26 = vec37.horizontalDistance();
            if (d26 > 0.01) {
                this.setDeltaMovement(vec37.add(vec37.x / d26 * 0.06, 0.0, vec37.z / d26 * 0.06));
            } else {
                Vec3 vec38 = this.getDeltaMovement();
                double d18 = vec38.x;
                double d19 = vec38.z;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.minecart.isRedstoneConductor(blockpos.west())) {
                        d18 = 0.02;
                    } else if (this.minecart.isRedstoneConductor(blockpos.east())) {
                        d18 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.minecart.isRedstoneConductor(blockpos.north())) {
                        d19 = 0.02;
                    } else if (this.minecart.isRedstoneConductor(blockpos.south())) {
                        d19 = -0.02;
                    }
                }
                this.setDeltaMovement(d18, vec38.y, d19);
            }
        }
        if ((abstractMinecart = this.minecart) instanceof CartAdvanceable) {
            CartAdvanceable cartAdvanceable = (CartAdvanceable)abstractMinecart;
            cartAdvanceable.advanceOnTrack(serverLevel);
        }
    }

    @Unique
    private boolean railcraft$shouldDoRailFunctions() {
        return (Boolean)this.minecart.getData(RailcraftAttachmentTypes.SHOULD_DO_RAIL_FUNCTIONS);
    }

    @Unique
    private BlockPos railcraft$getCurrentRailPosition(AbstractMinecart minecart, ServerLevel level) {
        int z;
        int y;
        int x = Mth.floor((double)minecart.getX());
        BlockPos pos = new BlockPos(x, y = Mth.floor((double)minecart.getY()), z = Mth.floor((double)minecart.getZ()));
        if (level.getBlockState(pos.below()).is(BlockTags.RAILS)) {
            pos = pos.below();
        }
        return pos;
    }
}

